/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.types;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa9;

public class OpaqueLsa9Test {
    private final byte[] packet = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] result;
    private String result1;
    private OpaqueLsaHeader opqueHeader;
    private OpaqueLsa9 opaqueLsa9;
    private ChannelBuffer channelBuffer;
    private OspfLsaType ospflsaType;
    private int result2;

    @Before
    public void setUp() throws Exception {
        this.opaqueLsa9 = new OpaqueLsa9(new OpaqueLsaHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.opaqueLsa9 = null;
        this.opqueHeader = null;
        this.channelBuffer = null;
        this.result = null;
        this.ospflsaType = null;
    }

    @Test
    public void testReadFrom() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(1);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(9);
        this.opqueHeader.setOpaqueType(9);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa9 = new OpaqueLsa9(this.opqueHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa9.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.opaqueLsa9, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(9);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(9);
        this.opqueHeader.setOpaqueType(9);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa9 = new OpaqueLsa9(this.opqueHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa9.readFrom(this.channelBuffer);
        this.result = this.opaqueLsa9.asBytes();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLsaBodyAsByteArray() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(9);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(9);
        this.opqueHeader.setOpaqueType(9);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.opaqueLsa9 = new OpaqueLsa9(this.opqueHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.opaqueLsa9.readFrom(this.channelBuffer);
        this.result = this.opaqueLsa9.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testHashcode() throws Exception {
        this.result2 = this.opaqueLsa9.hashCode();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        this.result1 = this.opaqueLsa9.toString();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.opaqueLsa9.setLsType(9);
        this.ospflsaType = this.opaqueLsa9.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.LINK_LOCAL_OPAQUE_LSA));
    }
}

