/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.types;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.subtypes.OspfLsaLink;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;

public class RouterLsaTest {
    private RouterLsa routerLsa;
    private int result1;
    private OspfLsaLink ospflsaLink;
    private byte[] inputArray;
    private LsaHeader lsaHeader;
    private ChannelBuffer channelBuffer;
    private byte[] result2;
    private OspfLsaType result3;

    @Before
    public void setUp() throws Exception {
        this.routerLsa = new RouterLsa();
    }

    @After
    public void tearDown() throws Exception {
        this.routerLsa = null;
        this.ospflsaLink = null;
        this.inputArray = null;
        this.lsaHeader = null;
        this.channelBuffer = null;
        this.result2 = null;
        this.result3 = null;
    }

    @Test
    public void testSetVirtualEndPoint() throws Exception {
        this.routerLsa.setVirtualEndPoint(true);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testSetAsBoundaryRouter() throws Exception {
        this.routerLsa.setAsBoundaryRouter(true);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testSetAreaBorderRouter() throws Exception {
        this.routerLsa.setAreaBorderRouter(true);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetNoLink() throws Exception {
        this.routerLsa.setNoLink(10);
        this.result1 = this.routerLsa.noLink();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testSetNoLink() throws Exception {
        this.routerLsa.setNoLink(10);
        this.result1 = this.routerLsa.noLink();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testAddRouterLink() throws Exception {
        this.routerLsa.setNoLink(0);
        this.ospflsaLink = this.createOspfLsaLink();
        this.routerLsa.addRouterLink(this.ospflsaLink);
        this.routerLsa.incrementLinkNo();
        this.result1 = this.routerLsa.noLink();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.ospflsaLink = this.createOspfLsaLink();
        this.routerLsa.addRouterLink(this.ospflsaLink);
        this.inputArray = this.createByteForRouterLsa();
        this.lsaHeader = this.createLsaHeader();
        this.routerLsa = new RouterLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputArray);
        this.routerLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testReadFrom1() throws Exception {
        byte[] temp = new byte[]{0, 0, 0};
        this.ospflsaLink = this.createOspfLsaLink();
        this.routerLsa.addRouterLink(this.ospflsaLink);
        this.inputArray = temp;
        this.lsaHeader = this.createLsaHeader();
        this.routerLsa = new RouterLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputArray);
        this.routerLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.routerLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result2 = this.routerLsa.asBytes();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLsaBodyAsByteArray() throws Exception {
        this.routerLsa.setAreaBorderRouter(true);
        this.routerLsa.setVirtualEndPoint(true);
        this.routerLsa.setAreaBorderRouter(true);
        this.ospflsaLink = this.createOspfLsaLink();
        this.routerLsa.addRouterLink(this.ospflsaLink);
        this.result2 = this.routerLsa.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.routerLsa.setLsType(1);
        this.result3 = this.routerLsa.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.result3, (Matcher)Matchers.is((Object)OspfLsaType.ROUTER));
    }

    @Test
    public void testIncrementLinkNo() throws Exception {
        this.routerLsa.setNoLink(1);
        this.routerLsa.incrementLinkNo();
        MatcherAssert.assertThat((Object)this.routerLsa.noLink(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetLsaHeader() throws Exception {
        this.lsaHeader = (LsaHeader)this.routerLsa.lsaHeader();
        MatcherAssert.assertThat((Object)this.lsaHeader, (Matcher)Matchers.instanceOf(RouterLsa.class));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.routerLsa.toString(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    private OspfLsaLink createOspfLsaLink() {
        this.ospflsaLink = new OspfLsaLink();
        this.ospflsaLink.setLinkId("10.226.165.164");
        this.ospflsaLink.setMetric(10);
        this.ospflsaLink.setTos(50);
        this.ospflsaLink.setLinkType(2);
        this.ospflsaLink.setLinkData("10.226.165.170");
        return this.ospflsaLink;
    }

    private byte[] createByteForRouterLsa() {
        byte[] packet = new byte[]{2, 1, 1, 52, -64, -88, 56, 1, -64, -88, 56, 1, 0, 100, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, -64, -88, 56, 1, 0, 10, 1, 1, 0, 0, 0, 40, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1};
        return packet;
    }

    private LsaHeader createLsaHeader() {
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setLsType(1);
        this.lsaHeader.setLsPacketLen(48);
        this.lsaHeader.setLsCheckSum(10);
        this.lsaHeader.setAge(4);
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.lsaHeader.setLsSequenceNo(250L);
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.lsaHeader.setOptions(2);
        return this.lsaHeader;
    }

    @Test
    public void testHashcode() throws Exception {
        this.result1 = this.routerLsa.hashCode();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

