/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.lsa.types;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsaType;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.types.SummaryLsa;

public class SummaryLsaTest {
    private SummaryLsa summaryLsa;
    private Ip4Address result;
    private int result1;
    private byte[] inputByteArray;
    private LsaHeader lsaHeader;
    private ChannelBuffer channelBuffer;
    private byte[] result2;
    private OspfLsaType ospflsaType;

    @Before
    public void setUp() throws Exception {
        this.summaryLsa = new SummaryLsa(new LsaHeader());
    }

    @After
    public void tearDown() throws Exception {
        this.summaryLsa = null;
        this.result = null;
        this.inputByteArray = null;
        this.lsaHeader = null;
        this.channelBuffer = null;
        this.result2 = null;
        this.ospflsaType = null;
    }

    @Test
    public void testGetNetworkMask() throws Exception {
        this.summaryLsa.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result = this.summaryLsa.networkMask();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testSetNetworkMask() throws Exception {
        this.summaryLsa.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result = this.summaryLsa.networkMask();
        MatcherAssert.assertThat((Object)this.result, (Matcher)Matchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testGetMetric() throws Exception {
        this.summaryLsa.setMetric(10);
        this.result1 = this.summaryLsa.metric();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testSetMetric() throws Exception {
        this.summaryLsa.setMetric(20);
        this.result1 = this.summaryLsa.metric();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Object)20));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.inputByteArray = this.createByteForNetworkLsa();
        this.lsaHeader = this.createLsaHeader();
        this.summaryLsa = new SummaryLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputByteArray);
        this.summaryLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.summaryLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testReadFrom1() throws Exception {
        byte[] temp = new byte[]{0, 0, 0};
        this.inputByteArray = temp;
        this.lsaHeader = this.createLsaHeader();
        this.summaryLsa = new SummaryLsa(this.lsaHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.inputByteArray);
        this.summaryLsa.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.summaryLsa, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result2 = this.summaryLsa.asBytes();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetLsaBodyAsByteArray() throws Exception {
        this.result2 = this.summaryLsa.getLsaBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetOspfLsaType() throws Exception {
        this.ospflsaType = this.summaryLsa.getOspfLsaType();
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospflsaType, (Matcher)Matchers.is((Object)OspfLsaType.SUMMARY));
    }

    private byte[] createByteForNetworkLsa() {
        byte[] packet = new byte[]{2, 1, 1, 52, -64, -88, 56, 1, -64, -88, 56, 1, 0, 100, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, -64, -88, 56, 1, 0, 10, 1, 1, 0, 0, 0, 40, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1};
        return packet;
    }

    private LsaHeader createLsaHeader() {
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setLsType(3);
        this.lsaHeader.setLsPacketLen(48);
        this.lsaHeader.setLsCheckSum(10);
        this.lsaHeader.setAge(4);
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.lsaHeader.setLsSequenceNo(250L);
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.lsaHeader.setOptions(2);
        return this.lsaHeader;
    }

    @Test
    public void testHashcode() throws Exception {
        this.result1 = this.summaryLsa.hashCode();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

