/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.ospfpacket;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessage;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessageWriter;
import org.onosproject.ospf.protocol.ospfpacket.types.DdPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.HelloPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.LsAcknowledge;
import org.onosproject.ospf.protocol.ospfpacket.types.LsRequest;
import org.onosproject.ospf.protocol.ospfpacket.types.LsUpdate;

public class OspfMessageWriterTest {
    private OspfMessageWriter ospfMessageWriter;
    private HelloPacket helloPacket;
    private DdPacket ddPacket;
    private LsAcknowledge lsAck;
    private LsRequest lsReq;
    private LsUpdate lsUpdate;

    @Before
    public void setUp() throws Exception {
        this.ospfMessageWriter = new OspfMessageWriter();
    }

    @After
    public void tearDown() throws Exception {
        this.ospfMessageWriter = null;
        this.helloPacket = null;
        this.ddPacket = null;
        this.lsAck = null;
        this.lsReq = null;
        this.lsUpdate = null;
    }

    @Test
    public void testWriteToBuffer() throws Exception {
        this.helloPacket = new HelloPacket();
        this.helloPacket.setAuthType(1);
        this.helloPacket.setOspftype(1);
        this.helloPacket.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.helloPacket.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.helloPacket.setChecksum(201);
        this.helloPacket.setAuthentication(2);
        this.helloPacket.setOspfPacLength(48);
        this.helloPacket.setOspfVer(2);
        this.helloPacket.setNetworkMask(Ip4Address.valueOf((String)"255.255.255.255"));
        this.helloPacket.setOptions(2);
        this.helloPacket.setHelloInterval(10);
        this.helloPacket.setRouterPriority(1);
        this.helloPacket.setRouterDeadInterval(40);
        this.helloPacket.setDr(Ip4Address.valueOf((String)"1.1.1.1"));
        this.helloPacket.setBdr(Ip4Address.valueOf((String)"2.2.2.2"));
        this.helloPacket.addNeighbor(Ip4Address.valueOf((String)"8.8.8.8"));
        this.helloPacket.setDestinationIp(Ip4Address.valueOf((String)"5.5.5.5"));
        this.ospfMessageWriter.writeToBuffer((OspfMessage)this.helloPacket, 7, 1);
        Assert.assertThat((Object)this.ospfMessageWriter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testWriteToBuffer1() throws Exception {
        this.ddPacket = new DdPacket();
        this.ddPacket.setAuthType(1);
        this.ddPacket.setOspftype(2);
        this.ddPacket.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.ddPacket.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.ddPacket.setChecksum(201);
        this.ddPacket.setAuthentication(2);
        this.ddPacket.setOspfPacLength(48);
        this.ddPacket.setOspfVer(2);
        this.ospfMessageWriter.writeToBuffer((OspfMessage)this.ddPacket, 1, 1);
        Assert.assertThat((Object)this.ospfMessageWriter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testWriteToBuffer2() throws Exception {
        this.lsAck = new LsAcknowledge();
        this.lsAck.setAuthType(1);
        this.lsAck.setOspftype(5);
        this.lsAck.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.lsAck.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.lsAck.setChecksum(201);
        this.lsAck.setAuthentication(2);
        this.lsAck.setOspfPacLength(48);
        this.lsAck.setOspfVer(2);
        this.ospfMessageWriter.writeToBuffer((OspfMessage)this.lsAck, 1, 1);
        Assert.assertThat((Object)this.ospfMessageWriter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testWriteToBuffer3() throws Exception {
        this.lsReq = new LsRequest();
        this.lsReq.setAuthType(1);
        this.lsReq.setOspftype(3);
        this.lsReq.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.lsReq.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.lsReq.setChecksum(201);
        this.lsReq.setAuthentication(2);
        this.lsReq.setOspfPacLength(48);
        this.lsReq.setOspfVer(2);
        this.ospfMessageWriter.writeToBuffer((OspfMessage)this.lsReq, 1, 1);
        Assert.assertThat((Object)this.ospfMessageWriter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testWriteToBuffer4() throws Exception {
        this.lsUpdate = new LsUpdate();
        this.lsUpdate.setAuthType(1);
        this.lsUpdate.setOspftype(3);
        this.lsUpdate.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.lsUpdate.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.lsUpdate.setChecksum(201);
        this.lsUpdate.setAuthentication(2);
        this.lsUpdate.setOspfPacLength(48);
        this.lsUpdate.setOspfVer(2);
        this.ospfMessageWriter.writeToBuffer((OspfMessage)this.lsUpdate, 1, 1);
        Assert.assertThat((Object)this.ospfMessageWriter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=Exception.class)
    public void testWriteToBuffer5() throws Exception {
        this.lsAck = new LsAcknowledge();
        this.lsAck.setAuthType(1);
        this.lsAck.setOspftype(5);
        this.lsAck.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.lsAck.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.lsAck.setChecksum(201);
        this.lsAck.setAuthentication(2);
        this.lsAck.setOspfPacLength(48);
        this.lsAck.setOspfVer(2);
        this.ospfMessageWriter.writeToBuffer((OspfMessage)this.lsAck, 1, 1);
    }
}

