/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.ospfpacket;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.protocol.ospfpacket.OspfPacketHeader;

public class OspfPacketHeaderTest {
    private final byte[] packet = new byte[]{0, 0, 0, 0};
    private OspfPacketHeader ospfPacketHeader;
    private ChannelBuffer channelBuffer;
    private byte[] result2;
    private int result;
    private Ip4Address result1;

    @Before
    public void setUp() throws Exception {
        this.ospfPacketHeader = new OspfPacketHeader();
    }

    @After
    public void tearDown() throws Exception {
        this.ospfPacketHeader = null;
        this.ospfPacketHeader = null;
        this.channelBuffer = null;
        this.result2 = null;
        this.result1 = null;
    }

    @Test
    public void testGetSourceIP() throws Exception {
        this.ospfPacketHeader.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        Assert.assertThat((Object)this.ospfPacketHeader.sourceIp(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetSourceIP() throws Exception {
        this.ospfPacketHeader.setSourceIp(Ip4Address.valueOf((String)"1.1.1.1"));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.ospfPacketHeader.sourceIp(), (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testGetOspfMessageType() throws Exception {
        Assert.assertThat((Object)this.ospfPacketHeader.ospfMessageType(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testReadFrom() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.ospfPacketHeader.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.ospfPacketHeader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result2 = this.ospfPacketHeader.asBytes();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetOspfVer() throws Exception {
        this.ospfPacketHeader.setOspfVer(2);
        this.result = this.ospfPacketHeader.ospfVersion();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testSetOspfVer() throws Exception {
        this.ospfPacketHeader.setOspfVer(2);
        this.result = this.ospfPacketHeader.ospfVersion();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testGetOspfType() throws Exception {
        this.ospfPacketHeader.setOspftype(3);
        this.result = this.ospfPacketHeader.ospfType();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testSetOspfType() throws Exception {
        this.ospfPacketHeader.setOspftype(3);
        this.result = this.ospfPacketHeader.ospfType();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testGetOspfPacLength() throws Exception {
        this.ospfPacketHeader.setOspfPacLength(3);
        this.result = this.ospfPacketHeader.ospfPacLength();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testSetOspfPacLength() throws Exception {
        this.ospfPacketHeader.setOspfPacLength(3);
        int result = this.ospfPacketHeader.ospfPacLength();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testGetRouterId() throws Exception {
        this.ospfPacketHeader.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.result1 = this.ospfPacketHeader.routerId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetRouterId() throws Exception {
        this.ospfPacketHeader.setRouterId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.result1 = this.ospfPacketHeader.routerId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testGetAreaId() throws Exception {
        this.ospfPacketHeader.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.result1 = this.ospfPacketHeader.areaId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetAreaId() throws Exception {
        this.ospfPacketHeader.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.result1 = this.ospfPacketHeader.areaId();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testGetChecksum() throws Exception {
        this.ospfPacketHeader.setChecksum(3);
        this.result = this.ospfPacketHeader.checksum();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testSetChecksum() throws Exception {
        this.ospfPacketHeader.setChecksum(3);
        this.result = this.ospfPacketHeader.checksum();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testGetAutype() throws Exception {
        this.ospfPacketHeader.setAuthType(3);
        this.result = this.ospfPacketHeader.authType();
        Assert.assertNotNull((Object)this.result);
        Assert.assertEquals((long)3L, (long)this.result);
    }

    @Test
    public void testSetAutype() throws Exception {
        this.ospfPacketHeader.setAuthType(3);
        this.result = this.ospfPacketHeader.authType();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testGetAuthentication() throws Exception {
        this.ospfPacketHeader.setAuthentication(3);
        this.result = this.ospfPacketHeader.authentication();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testSetAuthentication() throws Exception {
        this.ospfPacketHeader.setAuthentication(3);
        this.result = this.ospfPacketHeader.authentication();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testGetDestinationIP() throws Exception {
        this.ospfPacketHeader.setDestinationIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.result1 = this.ospfPacketHeader.destinationIp();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testSetDestinationIP() throws Exception {
        this.ospfPacketHeader.setDestinationIp(Ip4Address.valueOf((String)"1.1.1.1"));
        this.result1 = this.ospfPacketHeader.destinationIp();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"1.1.1.1")));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertThat((Object)this.ospfPacketHeader.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testPopulateHeader() throws Exception {
        this.ospfPacketHeader.populateHeader(new OspfPacketHeader());
        Assert.assertThat((Object)this.ospfPacketHeader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

