/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.ospfpacket.types;

import java.util.List;
import java.util.Vector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.ospfpacket.OspfPacketHeader;
import org.onosproject.ospf.protocol.ospfpacket.types.DdPacket;
import org.onosproject.ospf.protocol.util.OspfPacketType;

public class DdPacketTest {
    private byte[] packet;
    private byte[] result2;
    private DdPacket ddPacket;
    private Vector<LsaHeader> lsaHeaderList = new Vector();
    private int result;
    private long result1;
    private OpaqueLsaHeader opqueHeader;
    private OpaqueLsaHeader opqueHeader1;
    private List<LsaHeader> header;
    private OspfPacketHeader ospfPacketHeader;
    private ChannelBuffer channelBuffer;
    private LsaHeader lsaHeader;
    private long result3;
    private OspfPacketType ospfPacketType;

    @Before
    public void setUp() throws Exception {
        this.ddPacket = new DdPacket();
        this.ddPacket.setAuthType(1);
        this.ddPacket.setOspftype(2);
        this.ddPacket.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.ddPacket.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.ddPacket.setChecksum(201);
        this.ddPacket.setAuthentication(2);
        this.ddPacket.setOspfPacLength(48);
        this.ddPacket.setOspfVer(2);
    }

    @After
    public void tearDown() throws Exception {
        this.ddPacket = null;
        this.lsaHeaderList.clear();
        this.opqueHeader = null;
        this.opqueHeader1 = null;
        this.header = null;
        this.ospfPacketHeader = null;
        this.channelBuffer = null;
        this.lsaHeader = null;
        this.ospfPacketType = null;
    }

    @Test
    public void testIsOpaqueCapable() throws Exception {
        this.ddPacket.setIsOpaqueCapable(true);
        MatcherAssert.assertThat((Object)this.ddPacket.isOpaqueCapable(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSetIsOpaqueCapable() throws Exception {
        this.ddPacket.setIsOpaqueCapable(true);
        MatcherAssert.assertThat((Object)this.ddPacket.isOpaqueCapable(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetIms() throws Exception {
        this.ddPacket.setIms(1);
        this.result = this.ddPacket.ims();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetIms() throws Exception {
        this.ddPacket.setIms(1);
        this.result = this.ddPacket.ims();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetIsMaster() throws Exception {
        this.ddPacket.setIsMaster(2);
        this.result = this.ddPacket.isMaster();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testSetIsMaster() throws Exception {
        this.ddPacket.setIsMaster(2);
        this.result = this.ddPacket.isMaster();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testGetIsInitialize() throws Exception {
        this.ddPacket.setIsInitialize(3);
        this.result = this.ddPacket.isInitialize();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testSetIsInitialize() throws Exception {
        this.ddPacket.setIsInitialize(3);
        int result = this.ddPacket.isInitialize();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testGetIsMore() throws Exception {
        this.ddPacket.setIsMore(4);
        this.result = this.ddPacket.isMore();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testSetIsMore() throws Exception {
        this.ddPacket.setIsMore(4);
        int result = this.ddPacket.isMore();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testGetImtu() throws Exception {
        this.ddPacket.setImtu(5);
        this.result = this.ddPacket.imtu();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testSetImtu() throws Exception {
        this.ddPacket.setImtu(5);
        this.result = this.ddPacket.imtu();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testGetOptions() throws Exception {
        this.ddPacket.setOptions(2);
        this.result = this.ddPacket.options();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testSetOptions() throws Exception {
        this.ddPacket.setOptions(2);
        this.result = this.ddPacket.options();
        Assert.assertNotNull((Object)this.result);
        Assert.assertEquals((long)2L, (long)this.result);
    }

    @Test
    public void testGetSequenceno() throws Exception {
        this.ddPacket.setSequenceNo(2020L);
        this.result1 = this.ddPacket.sequenceNo();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)2020L));
    }

    @Test
    public void testSetSequenceno() throws Exception {
        this.ddPacket.setSequenceNo(2020L);
        this.result3 = this.ddPacket.sequenceNo();
        MatcherAssert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)2020L));
    }

    @Test
    public void testGetLsaHeaderList() throws Exception {
        this.ddPacket.addLsaHeader(this.createLsaHeader());
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(9);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(9);
        this.opqueHeader.setOpaqueType(9);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(2);
        this.ddPacket.setIsOpaqueCapable(true);
        this.ddPacket.addLsaHeader((LsaHeader)this.opqueHeader);
        this.opqueHeader1 = new OpaqueLsaHeader();
        this.opqueHeader1.setLsType(10);
        this.opqueHeader1.setLsPacketLen(48);
        this.opqueHeader1.setLsCheckSum(10);
        this.opqueHeader1.setAge(4);
        this.opqueHeader1.setOpaqueId(9);
        this.opqueHeader1.setOpaqueType(9);
        this.opqueHeader1.setLsSequenceNo(250L);
        this.opqueHeader1.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader1.setOptions(66);
        this.ddPacket.addLsaHeader((LsaHeader)this.opqueHeader1);
        this.header = this.ddPacket.getLsaHeaderList();
        MatcherAssert.assertThat(this.header, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSetLsaHeaderList() throws Exception {
        this.ddPacket.addLsaHeader(this.createLsaHeader());
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(9);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(9);
        this.opqueHeader.setOpaqueType(9);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(66);
        this.ddPacket.addLsaHeader((LsaHeader)this.opqueHeader);
        this.opqueHeader1 = new OpaqueLsaHeader();
        this.opqueHeader1.setLsType(10);
        this.opqueHeader1.setLsPacketLen(48);
        this.opqueHeader1.setLsCheckSum(10);
        this.opqueHeader1.setAge(4);
        this.opqueHeader1.setOpaqueId(9);
        this.opqueHeader1.setOpaqueType(9);
        this.opqueHeader1.setLsSequenceNo(250L);
        this.opqueHeader1.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader1.setOptions(2);
        this.ddPacket.addLsaHeader((LsaHeader)this.opqueHeader1);
        this.header = this.ddPacket.getLsaHeaderList();
        MatcherAssert.assertThat((Object)this.header.contains(this.createLsaHeader()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testAddLsaHeader() throws Exception {
        this.ddPacket.addLsaHeader(this.createLsaHeader());
        MatcherAssert.assertThat((Object)this.ddPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetOspfMessageType() throws Exception {
        this.ospfPacketType = this.ddPacket.ospfMessageType();
        MatcherAssert.assertThat((Object)this.ospfPacketType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ospfPacketType, (Matcher)CoreMatchers.is((Object)OspfPacketType.DD));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.ospfPacketHeader = new OspfPacketHeader();
        this.ospfPacketHeader.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfPacketHeader.setAuthentication(0);
        this.ospfPacketHeader.setAuthType(0);
        this.ospfPacketHeader.setChecksum(12345);
        this.ospfPacketHeader.setDestinationIp(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfPacketHeader.setOspfPacLength(56);
        this.ospfPacketHeader.setOspftype(2);
        this.ospfPacketHeader.setOspfVer(2);
        this.ospfPacketHeader.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfPacketHeader.setSourceIp(Ip4Address.valueOf((String)"3.3.3.3"));
        this.ddPacket.setIsOpaqueCapable(true);
        this.ddPacket.setOptions(66);
        this.ddPacket = new DdPacket(this.ospfPacketHeader);
        this.packet = this.createByteForDdPacket();
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.ddPacket.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.ddPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.ddPacket.ospfMessageType(), (Matcher)CoreMatchers.is((Object)OspfPacketType.DD));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result2 = this.ddPacket.asBytes();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetDdHeaderAsByteArray() throws Exception {
        this.opqueHeader = new OpaqueLsaHeader();
        this.opqueHeader.setLsType(9);
        this.opqueHeader.setLsPacketLen(48);
        this.opqueHeader.setLsCheckSum(10);
        this.opqueHeader.setAge(4);
        this.opqueHeader.setOpaqueId(9);
        this.opqueHeader.setOpaqueType(9);
        this.opqueHeader.setLsSequenceNo(250L);
        this.opqueHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader.setOptions(66);
        this.ddPacket.addLsaHeader((LsaHeader)this.opqueHeader);
        this.opqueHeader1 = new OpaqueLsaHeader();
        this.opqueHeader1.setLsType(10);
        this.opqueHeader1.setLsPacketLen(48);
        this.opqueHeader1.setLsCheckSum(10);
        this.opqueHeader1.setAge(4);
        this.opqueHeader1.setOpaqueId(9);
        this.opqueHeader1.setOpaqueType(9);
        this.opqueHeader1.setLsSequenceNo(250L);
        this.opqueHeader1.setAdvertisingRouter(Ip4Address.valueOf((String)"100.226.165.165"));
        this.opqueHeader1.setOptions(2);
        this.ddPacket.addLsaHeader((LsaHeader)this.opqueHeader1);
        this.result2 = this.ddPacket.getDdHeaderAsByteArray();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetDdBodyAsByteArray() throws Exception {
        this.lsaHeader = this.createLsaHeader();
        this.ddPacket.addLsaHeader(this.lsaHeader);
        this.result2 = this.ddPacket.getDdBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.ddPacket.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private LsaHeader createLsaHeader() {
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setAge(10);
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.lsaHeader.setLsCheckSum(222);
        this.lsaHeader.setLsPacketLen(48);
        this.lsaHeader.setLsSequenceNo(2020L);
        this.lsaHeader.setLsType(2);
        this.lsaHeader.setOptions(2);
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"10.226.165.165"));
        return this.lsaHeader;
    }

    private byte[] createByteForDdPacket() {
        byte[] ddPacket = new byte[]{5, -36, 66, 1, 65, 119, -87, 126, 0, 23, 2, 1, 10, 10, 10, 10, 10, 10, 10, 10, -128, 0, 0, 6, -69, 26, 0, 36};
        return ddPacket;
    }
}

