/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.ospfpacket.types;

import java.util.Vector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.protocol.ospfpacket.OspfPacketHeader;
import org.onosproject.ospf.protocol.ospfpacket.types.HelloPacket;
import org.onosproject.ospf.protocol.util.OspfPacketType;

public class HelloPacketTest {
    private boolean result1;
    private OspfPacketType ospfPacketType;
    private OspfPacketHeader ospfPacketHeader;
    private HelloPacket helloPacket;
    private Vector<String> neighborAddress = new Vector();
    private Ip4Address result;
    private int result2;
    private byte[] packet;
    private ChannelBuffer channelBuffer;
    private byte[] result3;

    @Before
    public void setUp() throws Exception {
        this.helloPacket = new HelloPacket();
        this.helloPacket.setAuthType(1);
        this.helloPacket.setOspftype(2);
        this.helloPacket.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.helloPacket.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.helloPacket.setChecksum(201);
        this.helloPacket.setAuthentication(2);
        this.helloPacket.setOspfPacLength(48);
        this.helloPacket.setOspfVer(2);
    }

    @After
    public void tearDown() throws Exception {
        this.helloPacket = null;
        this.result = null;
        this.ospfPacketType = null;
        this.ospfPacketHeader = null;
        this.packet = null;
        this.channelBuffer = null;
        this.result3 = null;
    }

    @Test
    public void testGetNetworkMask() throws Exception {
        this.helloPacket.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result = this.helloPacket.networkMask();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testSetNetworkMask() throws Exception {
        this.helloPacket.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.result = this.helloPacket.networkMask();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"10.226.165.164")));
    }

    @Test
    public void testSetBdr() throws Exception {
        this.helloPacket.setBdr(Ip4Address.valueOf((String)"10.226.165.166"));
        this.result = this.helloPacket.bdr();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"10.226.165.166")));
    }

    @Test
    public void testGetDr() throws Exception {
        this.helloPacket.setDr(Ip4Address.valueOf((String)"10.226.165.167"));
        this.result = this.helloPacket.dr();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"10.226.165.167")));
    }

    @Test
    public void testSetDr() throws Exception {
        this.helloPacket.setDr(Ip4Address.valueOf((String)"10.226.165.167"));
        this.result = this.helloPacket.dr();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)Ip4Address.valueOf((String)"10.226.165.167")));
    }

    @Test
    public void testAddNeighbor() throws Exception {
        this.helloPacket.addNeighbor(Ip4Address.valueOf((String)"10.226.165.170"));
        this.result1 = this.helloPacket.containsNeighbour(Ip4Address.valueOf((String)"10.226.165.170"));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testContainsNeighbour() throws Exception {
        this.helloPacket.addNeighbor(Ip4Address.valueOf((String)"10.226.165.200"));
        this.result1 = this.helloPacket.containsNeighbour(Ip4Address.valueOf((String)"10.226.165.200"));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetOptions() throws Exception {
        this.helloPacket.setOptions(10);
        this.result2 = this.helloPacket.options();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetOptions() throws Exception {
        this.helloPacket.setOptions(11);
        this.result2 = this.helloPacket.options();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)11));
    }

    @Test
    public void testGetRouterPriority() throws Exception {
        this.helloPacket.setRouterPriority(1);
        this.result2 = this.helloPacket.routerPriority();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSetRouterPriority() throws Exception {
        this.helloPacket.setRouterPriority(2);
        this.result2 = this.helloPacket.routerPriority();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testGetHelloInterval() throws Exception {
        this.helloPacket.setHelloInterval(10);
        this.result2 = this.helloPacket.helloInterval();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testSetHelloInterval() throws Exception {
        this.helloPacket.setHelloInterval(10);
        this.result2 = this.helloPacket.helloInterval();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testGetRouterDeadInterval() throws Exception {
        this.helloPacket.setRouterDeadInterval(50);
        this.result2 = this.helloPacket.routerDeadInterval();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)50));
    }

    @Test
    public void testSetRouterDeadInterval() throws Exception {
        this.helloPacket.setRouterDeadInterval(50);
        this.result2 = this.helloPacket.routerDeadInterval();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)50));
    }

    @Test
    public void testGetOspfMessageType() throws Exception {
        this.ospfPacketType = this.helloPacket.ospfMessageType();
        Assert.assertThat((Object)this.ospfPacketType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.ospfPacketType, (Matcher)CoreMatchers.is((Object)OspfPacketType.HELLO));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.ospfPacketHeader = new OspfPacketHeader();
        this.ospfPacketHeader.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfPacketHeader.setAuthentication(0);
        this.ospfPacketHeader.setAuthType(0);
        this.ospfPacketHeader.setChecksum(12345);
        this.ospfPacketHeader.setDestinationIp(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfPacketHeader.setOspfPacLength(56);
        this.ospfPacketHeader.setOspftype(1);
        this.ospfPacketHeader.setOspfVer(2);
        this.ospfPacketHeader.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfPacketHeader.setSourceIp(Ip4Address.valueOf((String)"3.3.3.3"));
        this.packet = this.createByteForHelloPacket();
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.helloPacket.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.helloPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.helloPacket.ospfMessageType(), (Matcher)CoreMatchers.is((Object)OspfPacketType.HELLO));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result3 = this.helloPacket.asBytes();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetHelloHeaderAsByteArray() throws Exception {
        this.result3 = this.helloPacket.getHelloHeaderAsByteArray();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetHelloBodyAsByteArray() throws Exception {
        this.neighborAddress.add("10.226.165.100");
        this.result3 = this.helloPacket.getHelloBodyAsByteArray();
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testReadHelloBody() throws Exception {
        this.helloPacket.getHelloBodyAsByteArray();
        Assert.assertThat((Object)this.helloPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertThat((Object)this.helloPacket.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private byte[] createByteForHelloPacket() {
        byte[] helloPacket = new byte[]{2, 1, 0, 44, -64, -88, -86, 8, 0, 0, 0, 1, 39, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 10, 2, 1, 0, 0, 0, 40, -64, -88, -86, 8, 0, 0, 0, 0};
        return helloPacket;
    }
}

