/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.ospfpacket.types;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.ospfpacket.OspfPacketHeader;
import org.onosproject.ospf.protocol.ospfpacket.types.LsAcknowledge;
import org.onosproject.ospf.protocol.util.OspfPacketType;

public class LsAcknowledgeTest {
    private LsaHeader lsaHeader;
    private LsAcknowledge lsAck;
    private OspfPacketType ospfPacketType;
    private OspfPacketHeader ospfPacketHeader;
    private byte[] result;
    private ChannelBuffer channelBuffer;
    private OpaqueLsaHeader opaqueLsaHeader;

    @Before
    public void setUp() throws Exception {
        this.lsaHeader = new LsaHeader();
        this.lsAck = new LsAcknowledge();
        this.lsAck.setAuthType(1);
        this.lsAck.setOspftype(5);
        this.lsAck.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.lsAck.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.lsAck.setChecksum(201);
        this.lsAck.setAuthentication(2);
        this.lsAck.setOspfPacLength(48);
        this.lsAck.setOspfVer(2);
    }

    @After
    public void tearDown() throws Exception {
        this.lsaHeader = null;
        this.lsAck = null;
        this.ospfPacketType = null;
        this.ospfPacketHeader = null;
        this.result = null;
        this.channelBuffer = null;
        this.opaqueLsaHeader = null;
    }

    @Test
    public void testGetLinkStateHeaders() throws Exception {
        this.lsaHeader = this.createLsaHeader();
        this.lsAck.addLinkStateHeader(this.lsaHeader);
        this.lsAck.addLinkStateHeader(this.lsaHeader);
        List headers = this.lsAck.getLinkStateHeaders();
        Assert.assertThat((Object)headers.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testAddLinkStateHeader() throws Exception {
        this.lsaHeader = this.createLsaHeader();
        this.lsAck.addLinkStateHeader(this.lsaHeader);
        this.lsAck.addLinkStateHeader(this.lsaHeader);
        Assert.assertThat((Object)this.lsAck, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetOspfMessageType() throws Exception {
        this.ospfPacketType = this.lsAck.ospfMessageType();
        Assert.assertThat((Object)this.ospfPacketType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.ospfPacketType, (Matcher)CoreMatchers.is((Object)OspfPacketType.LSAACK));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.ospfPacketHeader = new OspfPacketHeader();
        this.ospfPacketHeader.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfPacketHeader.setAuthentication(0);
        this.ospfPacketHeader.setAuthType(0);
        this.ospfPacketHeader.setChecksum(12345);
        this.ospfPacketHeader.setDestinationIp(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfPacketHeader.setOspfPacLength(56);
        this.ospfPacketHeader.setOspftype(5);
        this.ospfPacketHeader.setOspfVer(2);
        this.ospfPacketHeader.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfPacketHeader.setSourceIp(Ip4Address.valueOf((String)"3.3.3.3"));
        this.result = this.createByteForLSAck();
        this.lsAck = new LsAcknowledge(this.ospfPacketHeader);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.result);
        this.lsAck.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.lsAck, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.lsAck.ospfMessageType(), (Matcher)CoreMatchers.is((Object)OspfPacketType.LSAACK));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result = this.lsAck.asBytes();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsAckAsByteArray() throws Exception {
        this.result = this.lsAck.getLsAckAsByteArray();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsAckBodyAsByteArray() throws Exception {
        this.lsaHeader = this.createLsaHeader();
        this.opaqueLsaHeader = new OpaqueLsaHeader();
        this.lsAck.addLinkStateHeader(this.lsaHeader);
        this.lsAck.addLinkStateHeader((LsaHeader)this.opaqueLsaHeader);
        this.result = this.lsAck.getLsAckBodyAsByteArray();
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.lsAck.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private LsaHeader createLsaHeader() {
        this.lsaHeader = new LsaHeader();
        this.lsaHeader.setAge(10);
        this.lsaHeader.setLinkStateId("10.226.165.164");
        this.lsaHeader.setLsCheckSum(222);
        this.lsaHeader.setLsPacketLen(48);
        this.lsaHeader.setLsSequenceNo(2020L);
        this.lsaHeader.setLsType(5);
        this.lsaHeader.setOptions(2);
        this.lsaHeader.setAdvertisingRouter(Ip4Address.valueOf((String)"10.226.165.165"));
        return this.lsaHeader;
    }

    private byte[] createByteForLSAck() {
        byte[] lsAckPacket = new byte[]{2, 5, 0, 44, -64, -88, -86, 8, 0, 0, 0, 1, -30, -12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 16, 2, 1, -64, -88, -86, 2, -64, -88, -86, 2, -128, 0, 0, 1, 74, -114, 0, 48};
        return lsAckPacket;
    }
}

