/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.ospfpacket.types;

import java.net.UnknownHostException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.protocol.ospfpacket.OspfPacketHeader;
import org.onosproject.ospf.protocol.ospfpacket.subtype.LsRequestPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.LsRequest;
import org.onosproject.ospf.protocol.util.OspfPacketType;

public class LsRequestTest {
    private LsRequest lsRequest;
    private List<LsRequestPacket> result;
    private OspfPacketType ospfMessageType;
    private OspfPacketHeader ospfPacketHeader;
    private byte[] result1;
    private String result2;
    private ChannelBuffer channelBuffer;
    private LsRequestPacket lsRequestPacket;

    @Before
    public void setUp() throws Exception {
        this.lsRequest = new LsRequest();
        this.lsRequest.setAuthType(1);
        this.lsRequest.setOspftype(3);
        this.lsRequest.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.lsRequest.setAreaId(Ip4Address.valueOf((String)"10.226.165.163"));
        this.lsRequest.setChecksum(201);
        this.lsRequest.setAuthentication(2);
        this.lsRequest.setOspfPacLength(48);
        this.lsRequest.setOspfVer(2);
    }

    @After
    public void tearDown() throws Exception {
        this.lsRequest = null;
        this.result = null;
        this.ospfMessageType = null;
        this.ospfPacketHeader = null;
        this.result1 = null;
        this.channelBuffer = null;
        this.lsRequestPacket = null;
    }

    @Test
    public void testAddLinkStateRequests() throws Exception {
        this.lsRequest.addLinkStateRequests(this.createLsRequestPacket());
        this.result = this.lsRequest.getLinkStateRequests();
        Assert.assertThat(this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetLinkStateRequests() throws Exception {
        this.lsRequest.addLinkStateRequests(this.createLsRequestPacket());
        this.lsRequest.addLinkStateRequests(new LsRequestPacket());
        this.result = this.lsRequest.getLinkStateRequests();
        Assert.assertThat(this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testGetOspfMessageType() throws Exception {
        this.ospfMessageType = this.lsRequest.ospfMessageType();
        Assert.assertThat((Object)this.ospfMessageType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.ospfMessageType, (Matcher)CoreMatchers.is((Object)OspfPacketType.LSREQUEST));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.ospfPacketHeader = new OspfPacketHeader();
        this.ospfPacketHeader.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfPacketHeader.setAuthentication(0);
        this.ospfPacketHeader.setAuthType(0);
        this.ospfPacketHeader.setChecksum(12345);
        this.ospfPacketHeader.setDestinationIp(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfPacketHeader.setOspfPacLength(56);
        this.ospfPacketHeader.setOspftype(3);
        this.ospfPacketHeader.setOspfVer(2);
        this.ospfPacketHeader.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfPacketHeader.setSourceIp(Ip4Address.valueOf((String)"3.3.3.3"));
        this.lsRequest = new LsRequest(this.ospfPacketHeader);
        this.result1 = this.createByteLsReqestPacket();
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.result1);
        this.lsRequest.readFrom(this.channelBuffer);
        Assert.assertThat((Object)this.lsRequest, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.lsRequest.ospfMessageType(), (Matcher)CoreMatchers.is((Object)OspfPacketType.LSREQUEST));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result1 = this.lsRequest.asBytes();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsrHeaderAsByteArray() throws Exception {
        this.result1 = this.lsRequest.getLsrHeaderAsByteArray();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsrBodyAsByteArray() throws Exception {
        this.lsRequest.addLinkStateRequests(this.createLsRequestPacket());
        this.lsRequest.addLinkStateRequests(new LsRequestPacket());
        this.result1 = this.lsRequest.getLsrBodyAsByteArray();
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        this.result2 = this.lsRequest.toString();
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private LsRequestPacket createLsRequestPacket() throws UnknownHostException {
        this.lsRequestPacket = new LsRequestPacket();
        this.lsRequestPacket.setOwnRouterId("165");
        this.lsRequestPacket.setLinkStateId("10.226.165.164");
        this.lsRequestPacket.setLsType(2);
        return this.lsRequestPacket;
    }

    private byte[] createByteLsReqestPacket() {
        byte[] lsRequestPacket = new byte[]{2, 3, 0, 36, -64, -88, -86, 3, 0, 0, 0, 1, -67, -57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -64, -88, -86, 8, -64, -88, -86, 8};
        return lsRequestPacket;
    }
}

