/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.ospfpacket.types;

import java.util.List;
import java.util.Vector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.lsa.types.AsbrSummaryLsa;
import org.onosproject.ospf.protocol.lsa.types.ExternalLsa;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa10;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa11;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa9;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.lsa.types.SummaryLsa;
import org.onosproject.ospf.protocol.ospfpacket.OspfPacketHeader;
import org.onosproject.ospf.protocol.ospfpacket.types.LsUpdate;
import org.onosproject.ospf.protocol.util.OspfPacketType;

public class LsUpdateTest {
    private final byte[] packet1 = new byte[]{0, 0, 0, 2, 0, 10, 2, 1, 7, 7, 7, 7, 7, 7, 7, 7, -128, 0, 0, 2, 46, -126, 0, 48, 0, 0, 0, 2, 1, 1, 1, 1, 10, 10, 10, 7, 1, 0, 0, 10, 10, 10, 10, 0, -1, -1, -1, 0, 3, 0, 0, 10, 0, 10, 66, 10, 1, 0, 0, 1, 7, 7, 7, 7, -128, 0, 0, 1, -64, 79, 0, 116, 0, 1, 0, 4, 0, 0, 0, 0, 0, 2, 0, 84, 0, 1, 0, 1, 1, 0, 0, 0, 0, 2, 0, 4, 10, 10, 10, 0, 0, 5, 0, 4, 0, 0, 0, 0, 0, 6, 0, 4, 73, -104, -106, -128, 0, 7, 0, 4, 73, -104, -106, -128, 0, 8, 0, 32, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 0, 9, 0, 4, 0, 0, 0, 0};
    private final byte[] packet3 = new byte[]{0, 0, 0, 1, 0, 100, 2, 10, 1, 0, 0, 1, 9, 9, 9, 9, -128, 0, 0, 1, -7, 62, 0, -124, 0, 2, 0, 108, 0, 1, 0, 1, 2, 0, 0, 0, 0, 2, 0, 4, -64, -88, 7, -91, 0, 3, 0, 4, -64, -88, 7, -91, 0, 4, 0, 4, 0, 0, 0, 0, 0, 5, 0, 4, 0, 0, 0, 1, 0, 6, 0, 4, 0, 0, 0, 0, 0, 7, 0, 4, 0, 0, 0, 0, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 0, 0, 0, 0, -128, 2, 0, 4, 0, 0, 0, 1};
    private final byte[] packet2 = new byte[]{0, 0, 0, 1, 0, 1, 2, 2, -64, -88, -86, 8, -64, -88, -86, 8, -128, 0, 0, 1, 55, -73, 0, 32, -1, -1, -1, 0, -64, -88, -86, 3, -64, -88, -86, 8};
    private final byte[] packet4 = new byte[]{0, 0, 0, 1, 0, 100, 2, 9, 1, 0, 0, 1, 9, 9, 9, 9, -128, 0, 0, 1, -7, 62, 0, -124, 0, 2, 0, 108, 0, 1, 0, 1, 2, 0, 0, 0, 0, 2, 0, 4, -64, -88, 7, -91, 0, 3, 0, 4, -64, -88, 7, -91, 0, 4, 0, 4, 0, 0, 0, 0, 0, 5, 0, 4, 0, 0, 0, 1, 0, 6, 0, 4, 0, 0, 0, 0, 0, 7, 0, 4, 0, 0, 0, 0, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 0, 0, 0, 0, -128, 2, 0, 4, 0, 0, 0, 1};
    private final byte[] packet5 = new byte[]{0, 0, 0, 1, 0, 100, 2, 11, 1, 0, 0, 1, 9, 9, 9, 9, -128, 0, 0, 1, -7, 62, 0, -124, 0, 2, 0, 108, 0, 1, 0, 1, 2, 0, 0, 0, 0, 2, 0, 4, -64, -88, 7, -91, 0, 3, 0, 4, -64, -88, 7, -91, 0, 4, 0, 4, 0, 0, 0, 0, 0, 5, 0, 4, 0, 0, 0, 1, 0, 6, 0, 4, 0, 0, 0, 0, 0, 7, 0, 4, 0, 0, 0, 0, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 0, 0, 0, 0, -128, 2, 0, 4, 0, 0, 0, 1};
    private final byte[] packet6 = new byte[]{0, 0, 0, 1, 0, 100, 2, 3, 1, 0, 0, 1, 9, 9, 9, 9, -128, 0, 0, 1, -7, 62, 0, -124, 0, 2, 0, 108, 0, 1, 0, 1, 2, 0, 0, 0, 0, 2, 0, 4, -64, -88, 7, -91, 0, 3, 0, 4, -64, -88, 7, -91, 0, 4, 0, 4, 0, 0, 0, 0, 0, 5, 0, 4, 0, 0, 0, 1, 0, 6, 0, 4, 0, 0, 0, 0, 0, 7, 0, 4, 0, 0, 0, 0, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 0, 0, 0, 0, -128, 2, 0, 4, 0, 0, 0, 1};
    private final byte[] packet7 = new byte[]{0, 0, 0, 1, 0, 100, 2, 4, 1, 0, 0, 1, 9, 9, 9, 9, -128, 0, 0, 1, -7, 62, 0, -124, 0, 2, 0, 108, 0, 1, 0, 1, 2, 0, 0, 0, 0, 2, 0, 4, -64, -88, 7, -91, 0, 3, 0, 4, -64, -88, 7, -91, 0, 4, 0, 4, 0, 0, 0, 0, 0, 5, 0, 4, 0, 0, 0, 1, 0, 6, 0, 4, 0, 0, 0, 0, 0, 7, 0, 4, 0, 0, 0, 0, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 0, 0, 0, 0, -128, 2, 0, 4, 0, 0, 0, 1};
    private final byte[] packet8 = new byte[]{0, 0, 0, 2, 1, 4, 2, 1, 5, 5, 5, 5, 5, 5, 5, 5, -128, 0, 0, 4, -39, -84, 0, 36, 1, 0, 0, 1, -64, -88, 7, 90, -64, -88, 7, 92, 2, 0, 0, 10, 1, 4, 2, 4, -34, -34, -34, -34, 5, 5, 5, 5, -128, 0, 0, 1, 31, -93, 0, 28, 0, 0, 0, 0, 0, 0, 0, 10};
    private LsUpdate lsUpdate;
    private RouterLsa ospflsa;
    private NetworkLsa ospflsa1;
    private SummaryLsa ospflsa2;
    private AsbrSummaryLsa ospflsa3;
    private ExternalLsa ospflsa4;
    private Vector<OspfLsa> listLsa = new Vector();
    private List lsa;
    private int result;
    private OspfPacketType ospfMessageType;
    private OspfPacketHeader ospfPacketHeader;
    private byte[] result1;
    private ChannelBuffer channelBuffer;
    private OpaqueLsa10 opaqueLsa10;
    private OpaqueLsa9 opaqueLsa9;
    private OpaqueLsa11 opaqueLsa11;

    @Before
    public void setUp() throws Exception {
        this.lsUpdate = new LsUpdate();
        this.ospflsa = new RouterLsa();
        this.lsUpdate.setAuthType(1);
        this.lsUpdate.setOspftype(2);
        this.lsUpdate.setRouterId(Ip4Address.valueOf((String)"10.226.165.164"));
        this.lsUpdate.setAreaId(Ip4Address.valueOf((String)"10.226.165.100"));
        this.lsUpdate.setChecksum(201);
        this.lsUpdate.setAuthentication(2);
        this.lsUpdate.setOspfPacLength(48);
        this.lsUpdate.setOspfVer(2);
        this.ospflsa.setLsType(1);
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa);
        this.ospflsa1 = new NetworkLsa();
        this.ospflsa1.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.ospflsa1.setLsType(2);
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa1);
        this.ospflsa2 = new SummaryLsa(new LsaHeader());
        this.ospflsa2.setLsType(3);
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa2);
        this.ospflsa3 = new AsbrSummaryLsa(new LsaHeader());
        this.ospflsa3.setNetworkMask(Ip4Address.valueOf((String)"10.226.165.164"));
        this.ospflsa3.setLsType(4);
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa3);
        this.ospflsa4 = new ExternalLsa(new LsaHeader());
        this.ospflsa4.setLsType(5);
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa4);
    }

    @After
    public void tearDown() throws Exception {
        this.lsUpdate = null;
        this.ospflsa = null;
        this.ospflsa1 = null;
        this.ospflsa2 = null;
        this.ospflsa3 = null;
        this.ospflsa4 = null;
        this.listLsa.clear();
        this.lsa = null;
        this.ospfMessageType = null;
        this.ospfPacketHeader = null;
        this.result1 = null;
        this.channelBuffer = null;
        this.opaqueLsa9 = null;
        this.opaqueLsa10 = null;
        this.opaqueLsa11 = null;
    }

    @Test
    public void testGetListLsa() throws Exception {
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa);
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa);
        this.lsa = this.lsUpdate.getLsaList();
        MatcherAssert.assertThat((Object)this.lsa, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.lsa.size(), (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testAddLsa() throws Exception {
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa);
        MatcherAssert.assertThat((Object)this.lsUpdate, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetNoLsa() throws Exception {
        this.lsUpdate.setNumberOfLsa(5);
        this.result = this.lsUpdate.noLsa();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testSetNoLsa() throws Exception {
        this.lsUpdate.setNumberOfLsa(5);
        this.result = this.lsUpdate.noLsa();
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)5));
    }

    @Test
    public void testGetOspfMessageType() throws Exception {
        this.ospfMessageType = this.lsUpdate.ospfMessageType();
        MatcherAssert.assertThat((Object)this.ospfMessageType, (Matcher)CoreMatchers.is((Object)OspfPacketType.LSUPDATE));
    }

    @Test
    public void testReadFrom() throws Exception {
        this.ospfPacketHeader = new OspfPacketHeader();
        this.ospfPacketHeader.setAreaId(Ip4Address.valueOf((String)"1.1.1.1"));
        this.ospfPacketHeader.setAuthentication(0);
        this.ospfPacketHeader.setAuthType(0);
        this.ospfPacketHeader.setChecksum(12345);
        this.ospfPacketHeader.setDestinationIp(Ip4Address.valueOf((String)"10.10.10.10"));
        this.ospfPacketHeader.setOspfPacLength(56);
        this.ospfPacketHeader.setOspftype(4);
        this.ospfPacketHeader.setOspfVer(2);
        this.ospfPacketHeader.setRouterId(Ip4Address.valueOf((String)"2.2.2.2"));
        this.ospfPacketHeader.setSourceIp(Ip4Address.valueOf((String)"3.3.3.3"));
        this.lsUpdate = new LsUpdate(this.ospfPacketHeader);
        this.result1 = this.createLsUpdatePacket();
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.result1);
        this.lsUpdate.readFrom(this.channelBuffer);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet1);
        this.lsUpdate.readFrom(this.channelBuffer);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet2);
        this.lsUpdate.readFrom(this.channelBuffer);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet3);
        this.lsUpdate.readFrom(this.channelBuffer);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet4);
        this.lsUpdate.readFrom(this.channelBuffer);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet5);
        this.lsUpdate.readFrom(this.channelBuffer);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet6);
        this.lsUpdate.readFrom(this.channelBuffer);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet7);
        this.lsUpdate.readFrom(this.channelBuffer);
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet8);
        this.lsUpdate.readFrom(this.channelBuffer);
        MatcherAssert.assertThat((Object)this.lsUpdate, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.lsUpdate.ospfMessageType(), (Matcher)CoreMatchers.is((Object)OspfPacketType.LSUPDATE));
    }

    @Test
    public void testAsBytes() throws Exception {
        this.result1 = this.lsUpdate.asBytes();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsuHeaderAsByteArray() throws Exception {
        this.result1 = this.lsUpdate.getLsuHeaderAsByteArray();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsuBodyAsByteArray() throws Exception {
        this.lsUpdate.setNumberOfLsa(8);
        this.lsUpdate.addLsa((OspfLsa)this.ospflsa3);
        this.opaqueLsa9 = new OpaqueLsa9(new OpaqueLsaHeader());
        this.opaqueLsa9.setLsType(9);
        this.lsUpdate.addLsa((OspfLsa)this.opaqueLsa9);
        this.opaqueLsa10 = new OpaqueLsa10(new OpaqueLsaHeader());
        this.opaqueLsa10.setLsType(10);
        this.lsUpdate.addLsa((OspfLsa)this.opaqueLsa10);
        this.opaqueLsa11 = new OpaqueLsa11(new OpaqueLsaHeader());
        this.opaqueLsa10.setLsType(11);
        this.lsUpdate.addLsa((OspfLsa)this.opaqueLsa11);
        this.result1 = this.lsUpdate.getLsuBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLsuBodyAsByteArray1() throws Exception {
        this.lsUpdate.setNumberOfLsa(8);
        this.opaqueLsa10 = new OpaqueLsa10(new OpaqueLsaHeader());
        this.opaqueLsa10.setLsType(10);
        this.lsUpdate.addLsa((OspfLsa)this.opaqueLsa10);
        MatcherAssert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testGetLsuBodyAsByteArray2() throws Exception {
        this.opaqueLsa11 = new OpaqueLsa11(new OpaqueLsaHeader());
        this.opaqueLsa11.setLsType(11);
        this.lsUpdate.addLsa((OspfLsa)this.opaqueLsa11);
        this.result1 = this.lsUpdate.getLsuBodyAsByteArray();
        MatcherAssert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testToString() throws Exception {
        MatcherAssert.assertThat((Object)this.lsUpdate.toString(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private byte[] createLsUpdatePacket() {
        byte[] lsUpdatePacket = new byte[]{0, 0, 0, 7, 0, 2, 2, 1, -64, -88, -86, 3, -64, -88, -86, 3, -128, 0, 0, 1, 58, -100, 0, 48, 2, 0, 0, 2, -64, -88, -86, 0, -1, -1, -1, 0, 3, 0, 0, 10, -64, -88, -86, 0, -1, -1, -1, 0, 3, 0, 0, 10, 0, 3, 2, 5, 80, -44, 16, 0, -64, -88, -86, 2, -128, 0, 0, 1, 42, 73, 0, 36, -1, -1, -1, -1, -128, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 5, -108, 121, -85, 0, -64, -88, -86, 2, -128, 0, 0, 1, 52, -91, 0, 36, -1, -1, -1, 0, -128, 0, 0, 20, -64, -88, -86, 1, 0, 0, 0, 0, 0, 3, 2, 5, -64, -126, 120, 0, -64, -88, -86, 2, -128, 0, 0, 1, -45, 25, 0, 36, -1, -1, -1, 0, -128, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 5, -64, -88, 0, 0, -64, -88, -86, 2, -128, 0, 0, 1, 55, 8, 0, 36, -1, -1, -1, 0, -128, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 5, -64, -88, 1, 0, -64, -88, -86, 2, -128, 0, 0, 1, 44, 18, 0, 36, -1, -1, -1, 0, -128, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 5, -64, -88, -84, 0, -64, -88, -86, 2, -128, 0, 0, 1, 51, 65, 0, 36, -1, -1, -1, 0, -128, 0, 0, 20, -64, -88, -86, 10, 0, 0, 0, 0};
        return lsUpdatePacket;
    }
}

