/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.controller.OspfLsa;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.lsa.OpaqueLsaHeader;
import org.onosproject.ospf.protocol.lsa.types.AsbrSummaryLsa;
import org.onosproject.ospf.protocol.lsa.types.ExternalLsa;
import org.onosproject.ospf.protocol.lsa.types.NetworkLsa;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa10;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa11;
import org.onosproject.ospf.protocol.lsa.types.OpaqueLsa9;
import org.onosproject.ospf.protocol.lsa.types.RouterLsa;
import org.onosproject.ospf.protocol.lsa.types.SummaryLsa;
import org.onosproject.ospf.protocol.ospfpacket.OspfMessage;
import org.onosproject.ospf.protocol.ospfpacket.types.DdPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.HelloPacket;
import org.onosproject.ospf.protocol.ospfpacket.types.LsAcknowledge;
import org.onosproject.ospf.protocol.ospfpacket.types.LsRequest;
import org.onosproject.ospf.protocol.ospfpacket.types.LsUpdate;
import org.onosproject.ospf.protocol.util.ChecksumCalculator;

public class ChecksumCalculatorTest {
    private final int ospfChecksumPos1 = 12;
    private final int ospfChecksumPos2 = 13;
    private final int lsaChecksumPos1 = 16;
    private final int lsaChecksumPos2 = 17;
    private final byte[] updatePacket = new byte[]{1, 1, 1, 1, 2, 4, 0, -96, 9, 9, 9, 9, 5, 5, 5, 5, 62, 125, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 100, 2, 10, 1, 0, 0, 1, 9, 9, 9, 9, -128, 0, 0, 1, -7, 62, 0, -124, 0, 2, 0, 108, 0, 1, 0, 1, 2, 0, 0, 0, 0, 2, 0, 4, -64, -88, 7, -91, 0, 3, 0, 4, -64, -88, 7, -91, 0, 4, 0, 4, 0, 0, 0, 0, 0, 5, 0, 4, 0, 0, 0, 1, 0, 6, 0, 4, 0, 0, 0, 0, 0, 7, 0, 4, 0, 0, 0, 0, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 0, 0, 0, 0, -128, 2, 0, 4, 0, 0, 0, 1};
    private final byte[] helloPacket = new byte[]{2, 1, 0, 44, -64, -88, -86, 8, 0, 0, 0, 1, 39, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 10, 2, 1, 0, 0, 0, 40, -64, -88, -86, 8, 0, 0, 0, 0};
    private final byte[] rlsa = new byte[]{14, 16, 2, 1, -64, -88, -86, 2, -64, -88, -86, 2, -128, 0, 0, 1, 74, -114, 0, 48, 2, 0, 0, 2, -64, -88, -86, 0, -1, -1, -1, 0, 3, 0, 0, 10, -64, -88, -86, 0, -1, -1, -1, 0, 3, 0, 0, 10};
    private ChecksumCalculator checksumCalculator;
    private boolean validate;
    private HelloPacket hello;
    private LsUpdate message;
    private DdPacket message1;
    private LsRequest message2;
    private RouterLsa router;
    private LsAcknowledge lsack;
    private ExternalLsa external;
    private NetworkLsa external1;
    private SummaryLsa external2;
    private AsbrSummaryLsa external3;
    private OpaqueLsa9 external4;
    private OpaqueLsa10 external5;
    private OpaqueLsa11 external6;
    private byte[] result;

    @Before
    public void setUp() throws Exception {
        this.checksumCalculator = new ChecksumCalculator();
    }

    @After
    public void tearDown() throws Exception {
        this.checksumCalculator = null;
        this.hello = null;
        this.message = null;
        this.message1 = null;
        this.message2 = null;
        this.router = null;
        this.lsack = null;
        this.external = null;
        this.external1 = null;
        this.external2 = null;
        this.external3 = null;
        this.result = null;
    }

    @Test
    public void testConvertToSixteenBits() throws Exception {
        int num = ChecksumCalculator.convertToSixteenBits((String)"16cdd");
        MatcherAssert.assertThat((Object)num, (Matcher)CoreMatchers.is((Object)27870));
    }

    @Test
    public void testIsValidOspfCheckSum() throws Exception {
        this.hello = new HelloPacket();
        this.hello.setOspfVer(2);
        this.hello.setOspftype(1);
        this.hello.setOspfPacLength(172);
        this.hello.setRouterId(Ip4Address.valueOf((String)"192.168.170.3"));
        this.hello.setAreaId(Ip4Address.valueOf((String)"0.0.0.1"));
        this.hello.setChecksum(5537);
        this.hello.setAuthType(0);
        this.hello.setAuthentication(0);
        this.validate = this.checksumCalculator.isValidOspfCheckSum((OspfMessage)this.hello, 12, 13);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)false));
        this.lsack = new LsAcknowledge();
        this.lsack.setOspfVer(2);
        this.lsack.setOspftype(5);
        this.lsack.setOspfPacLength(172);
        this.lsack.setRouterId(Ip4Address.valueOf((String)"192.168.170.3"));
        this.lsack.setAreaId(Ip4Address.valueOf((String)"0.0.0.1"));
        this.lsack.setChecksum(37537);
        this.lsack.setAuthType(0);
        this.lsack.setAuthentication(0);
        this.validate = this.checksumCalculator.isValidOspfCheckSum((OspfMessage)this.lsack, 12, 13);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)true));
        this.message = new LsUpdate();
        this.message.setOspfVer(2);
        this.message.setOspftype(5);
        this.message.setOspfPacLength(172);
        this.message.setRouterId(Ip4Address.valueOf((String)"192.168.170.3"));
        this.message.setAreaId(Ip4Address.valueOf((String)"0.0.0.1"));
        this.message.setChecksum(37537);
        this.message.setAuthType(0);
        this.message.setAuthentication(0);
        this.validate = this.checksumCalculator.isValidOspfCheckSum((OspfMessage)this.message, 12, 13);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)true));
        this.message1 = new DdPacket();
        this.message1.setOspfVer(2);
        this.message1.setOspftype(5);
        this.message1.setOspfPacLength(172);
        this.message1.setRouterId(Ip4Address.valueOf((String)"192.168.170.3"));
        this.message1.setAreaId(Ip4Address.valueOf((String)"0.0.0.1"));
        this.message1.setChecksum(37537);
        this.message1.setAuthType(0);
        this.message1.setAuthentication(0);
        this.validate = this.checksumCalculator.isValidOspfCheckSum((OspfMessage)this.message1, 12, 13);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)true));
        this.message2 = new LsRequest();
        this.message2.setOspfVer(2);
        this.message2.setOspftype(5);
        this.message2.setOspfPacLength(172);
        this.message2.setRouterId(Ip4Address.valueOf((String)"192.168.170.3"));
        this.message2.setAreaId(Ip4Address.valueOf((String)"0.0.0.1"));
        this.message2.setChecksum(37537);
        this.message2.setAuthType(0);
        this.message2.setAuthentication(0);
        this.validate = this.checksumCalculator.isValidOspfCheckSum((OspfMessage)this.message2, 12, 13);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsValidLsaCheckSum() throws Exception {
        this.router = new RouterLsa();
        this.router.setAge(1);
        this.router.setOptions(2);
        this.router.setLsType(1);
        this.router.setLinkStateId("192.168.170.3");
        this.router.setAdvertisingRouter(Ip4Address.valueOf((String)"192.168.170.3"));
        this.router.setLsSequenceNo(0x80000001L);
        this.router.setLsCheckSum(49499);
        this.router.setLsPacketLen(48);
        this.validate = this.checksumCalculator.isValidLsaCheckSum((OspfLsa)this.router, this.router.lsType(), 16, 17);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsValidLsaCheckSum4() throws Exception {
        this.external = new ExternalLsa(new LsaHeader());
        this.external.setAge(2);
        this.external.setOptions(2);
        this.external.setLsType(5);
        this.external.setLinkStateId("80.212.16.0");
        this.external.setAdvertisingRouter(Ip4Address.valueOf((String)"192.168.170.2"));
        this.external.setLsSequenceNo(0x80000001L);
        this.external.setLsCheckSum(25125);
        this.external.setLsPacketLen(36);
        this.validate = this.checksumCalculator.isValidLsaCheckSum((OspfLsa)this.external, this.external.lsType(), 16, 17);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=Exception.class)
    public void testIsValidLsaCheckSum5() throws Exception {
        this.external1 = new NetworkLsa();
        this.external1.setAge(2);
        this.external1.setOptions(2);
        this.external1.setLsType(2);
        this.external1.setLinkStateId("80.212.16.0");
        this.external1.setAdvertisingRouter(Ip4Address.valueOf((String)"192.168.170.2"));
        this.external1.setLsSequenceNo(0x80000001L);
        this.external1.setLsCheckSum(25125);
        this.external1.setLsPacketLen(36);
        this.validate = this.checksumCalculator.isValidLsaCheckSum((OspfLsa)this.external1, this.external1.lsType(), 16, 17);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsValidLsaCheckSum6() throws Exception {
        this.external2 = new SummaryLsa(new LsaHeader());
        this.external2.setAge(2);
        this.external2.setOptions(2);
        this.external2.setLsType(3);
        this.external2.setLinkStateId("80.212.16.0");
        this.external2.setAdvertisingRouter(Ip4Address.valueOf((String)"192.168.170.2"));
        this.external2.setLsSequenceNo(0x80000001L);
        this.external2.setLsCheckSum(25125);
        this.external2.setLsPacketLen(36);
        this.validate = this.checksumCalculator.isValidLsaCheckSum((OspfLsa)this.external2, this.external2.lsType(), 16, 17);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=Exception.class)
    public void testIsValidLsaCheckSum7() throws Exception {
        this.external3 = new AsbrSummaryLsa(new LsaHeader());
        this.external3.setAge(2);
        this.external3.setOptions(2);
        this.external3.setLsType(4);
        this.external3.setLinkStateId("80.212.16.0");
        this.external3.setAdvertisingRouter(Ip4Address.valueOf((String)"192.168.170.2"));
        this.external3.setLsSequenceNo(0x80000001L);
        this.external3.setLsCheckSum(25125);
        this.external3.setLsPacketLen(36);
        this.validate = this.checksumCalculator.isValidLsaCheckSum((OspfLsa)this.external3, this.external3.lsType(), 16, 17);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=Exception.class)
    public void testIsValidLsaCheckSum1() throws Exception {
        this.external4 = new OpaqueLsa9(new OpaqueLsaHeader());
        this.external4.setAge(2);
        this.external4.setOptions(2);
        this.external4.setLsType(9);
        this.external4.setLinkStateId("80.212.16.0");
        this.external4.setAdvertisingRouter(Ip4Address.valueOf((String)"192.168.170.2"));
        this.external4.setLsSequenceNo(0x80000001L);
        this.external4.setLsCheckSum(25125);
        this.external4.setLsPacketLen(36);
        this.validate = this.checksumCalculator.isValidLsaCheckSum((OspfLsa)this.external4, this.external4.lsType(), 16, 17);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=Exception.class)
    public void testIsValidLsaCheckSum2() throws Exception {
        this.external5 = new OpaqueLsa10(new OpaqueLsaHeader());
        this.external5.setAge(2);
        this.external5.setOptions(2);
        this.external5.setLsType(10);
        this.external5.setLinkStateId("80.212.16.0");
        this.external5.setAdvertisingRouter(Ip4Address.valueOf((String)"192.168.170.2"));
        this.external5.setLsSequenceNo(0x80000001L);
        this.external5.setLsCheckSum(25125);
        this.external5.setLsPacketLen(36);
        this.validate = this.checksumCalculator.isValidLsaCheckSum((OspfLsa)this.external5, this.external5.lsType(), 16, 17);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=Exception.class)
    public void testIsValidLsaCheckSum3() throws Exception {
        this.external6 = new OpaqueLsa11(new OpaqueLsaHeader());
        this.external6.setAge(2);
        this.external6.setOptions(2);
        this.external6.setLsType(10);
        this.external6.setLinkStateId("80.212.16.0");
        this.external6.setAdvertisingRouter(Ip4Address.valueOf((String)"192.168.170.2"));
        this.external6.setLsSequenceNo(0x80000001L);
        this.external6.setLsCheckSum(25125);
        this.external6.setLsPacketLen(36);
        this.validate = this.checksumCalculator.isValidLsaCheckSum((OspfLsa)this.external6, this.external6.lsType(), 16, 17);
        MatcherAssert.assertThat((Object)this.validate, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testValidateLsaCheckSum() throws Exception {
        MatcherAssert.assertThat((Object)this.checksumCalculator.validateLsaCheckSum(this.rlsa, 16, 17), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testValidateOspfCheckSum() throws Exception {
        MatcherAssert.assertThat((Object)this.checksumCalculator.validateOspfCheckSum(this.helloPacket, 12, 13), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCalculateLsaChecksum() throws Exception {
        this.result = this.checksumCalculator.calculateLsaChecksum(this.rlsa, 16, 17);
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testCalculateOspfCheckSum() throws Exception {
        this.result = this.checksumCalculator.calculateOspfCheckSum(this.helloPacket, 12, 13);
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.result = this.checksumCalculator.calculateOspfCheckSum(this.updatePacket, 12, 13);
        MatcherAssert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

