/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.protocol.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onosproject.ospf.protocol.lsa.LsaHeader;
import org.onosproject.ospf.protocol.util.OspfUtil;

public class OspfUtilTest {
    private final int ospfChecksumPos1 = 12;
    private final int ospfChecksumPos2 = 13;
    private final int lsaChecksumPos1 = 16;
    private final int lsaChecksumPos2 = 17;
    private final int ospfLengthPos1 = 2;
    private final int ospfLengthPos2 = 3;
    private final int lsaLengthPos1 = 18;
    private final int lsaLengthPos2 = 19;
    private final byte[] input = new byte[]{0, 2};
    private final byte[] packet = new byte[]{2, 1, 0, 52, -64, -88, 56, 1, -64, -88, 56, 1, 0, 100, 0, 100, 0, 0, 0, 0, 0, 0, 0, 0, -64, -88, 56, 1, 0, 10, 1, 1, 0, 0, 0, 40, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1, -64, -88, 56, 1};
    private final byte[] rLsa = new byte[]{14, 16, 2, 1, -64, -88, -86, 2, -64, -88, -86, 2, -128, 0, 0, 1, 74, -114, 0, 48, 2, 0, 0, 2, -64, -88, -86, 0, -1, -1, -1, 0, 3, 0, 0, 10, -64, -88, -86, 0, -1, -1, -1, 0, 3, 0, 0, 10};
    private final byte[] opaqueheader = new byte[]{14, 16, 2, 1, -64, -88, -86, 2, -64, -88, -86, 2, -128, 0, 0, 1, 74, -114, 0, 48};
    private int num;
    private int result;
    private int input2;
    private long input4;
    private ChannelBuffer channelBuffer;
    private byte[] result1;
    private LsaHeader lsaHeader;
    private boolean result2;
    private long result3;

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        this.channelBuffer = null;
        this.result1 = null;
        this.lsaHeader = null;
    }

    @Test
    public void testByteToInteger() throws Exception {
        this.result = OspfUtil.byteToInteger((byte[])this.input);
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testByteToLong() throws Exception {
        this.result3 = OspfUtil.byteToLong((byte[])this.input);
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testByteToLong1() throws Exception {
        this.result3 = OspfUtil.byteToLong((byte[])this.input);
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result3, (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void testByteToInteger1() throws Exception {
        this.result = OspfUtil.byteToInteger((byte[])this.input);
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.result, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testCreateRandomNumber() throws Exception {
        this.num = OspfUtil.createRandomNumber();
        Assert.assertThat((Object)this.num, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testReadLsaHeader2() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.packet);
        this.lsaHeader = OspfUtil.readLsaHeader((ChannelBuffer)this.channelBuffer);
        Assert.assertThat((Object)this.lsaHeader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testReadLsaHeader1() throws Exception {
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])this.opaqueheader);
        this.lsaHeader = OspfUtil.readLsaHeader((ChannelBuffer)this.channelBuffer);
        Assert.assertThat((Object)this.lsaHeader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testConvertToTwoBytes() throws Exception {
        this.input2 = 4;
        this.result1 = OspfUtil.convertToTwoBytes((int)this.input2);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)2));
        this.input2 = 1000;
        this.result1 = OspfUtil.convertToTwoBytes((int)this.input2);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testConvertToThreeBytes() throws Exception {
        this.input2 = 1000000;
        this.result1 = OspfUtil.convertToThreeBytes((int)this.input2);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)3));
        this.input2 = 1000;
        this.result1 = OspfUtil.convertToThreeBytes((int)this.input2);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)3));
        this.input2 = 1;
        this.result1 = OspfUtil.convertToThreeBytes((int)this.input2);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testConvertToFourBytes() throws Exception {
        this.input4 = 214748364110L;
        this.result1 = OspfUtil.convertToFourBytes((long)this.input4);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)4));
        this.input4 = 1000000L;
        this.result1 = OspfUtil.convertToFourBytes((long)this.input4);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)4));
        this.input4 = 10000L;
        this.result1 = OspfUtil.convertToFourBytes((long)this.input4);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)4));
        this.input4 = 1L;
        this.result1 = OspfUtil.convertToFourBytes((long)this.input4);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testConvertToFourBytes1() throws Exception {
        this.input4 = 0x7FFFFFF3L;
        this.result1 = OspfUtil.convertToFourBytes((long)this.input4);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)4));
        this.input4 = 1000000L;
        this.result1 = OspfUtil.convertToFourBytes((long)this.input4);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)4));
        this.input4 = 10000L;
        this.result1 = OspfUtil.convertToFourBytes((long)this.input4);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)4));
        this.input4 = 1L;
        this.result1 = OspfUtil.convertToFourBytes((long)this.input4);
        Assert.assertThat((Object)this.result1.length, (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testAddLengthAndCheckSum() throws Exception {
        this.result1 = OspfUtil.addLengthAndCheckSum((byte[])this.packet, (int)2, (int)3, (int)12, (int)13);
        Assert.assertThat((Object)this.result1[12], (Matcher)CoreMatchers.is((Object)this.packet[12]));
        Assert.assertThat((Object)this.result1[13], (Matcher)CoreMatchers.is((Object)this.packet[13]));
        Assert.assertThat((Object)this.result1[2], (Matcher)CoreMatchers.is((Object)this.packet[2]));
        Assert.assertThat((Object)this.result1[3], (Matcher)CoreMatchers.is((Object)this.packet[3]));
    }

    @Test
    public void testAddMetadata() throws Exception {
        this.result1 = OspfUtil.addMetadata((byte[])this.packet, (int)123, (Ip4Address)Ip4Address.valueOf((String)"1.1.1.1"));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testAddLsaLengthAndCheckSum() throws Exception {
        this.result1 = OspfUtil.addLengthAndCheckSum((byte[])this.rLsa, (int)18, (int)19, (int)16, (int)17);
        Assert.assertThat((Object)this.result1[18], (Matcher)CoreMatchers.is((Object)this.rLsa[18]));
        Assert.assertThat((Object)this.result1[19], (Matcher)CoreMatchers.is((Object)this.rLsa[19]));
        Assert.assertThat((Object)this.result1[16], (Matcher)CoreMatchers.is((Object)this.rLsa[16]));
        Assert.assertThat((Object)this.result1[17], (Matcher)CoreMatchers.is((Object)this.rLsa[17]));
    }

    @Test
    public void testAddMetaData() throws Exception {
        this.result1 = OspfUtil.addMetadata((byte[])this.packet, (int)1, (Ip4Address)Ip4Address.valueOf((String)"2.2.2.2"));
        Assert.assertThat((Object)this.result1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSameNetwork() throws Exception {
        this.result2 = OspfUtil.sameNetwork((Ip4Address)Ip4Address.valueOf((String)"10.10.10.10"), (Ip4Address)Ip4Address.valueOf((String)"10.10.10.11"), (Ip4Address)Ip4Address.valueOf((String)"255.255.255.255"));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)false));
        this.result2 = OspfUtil.sameNetwork((Ip4Address)Ip4Address.valueOf((String)"10.10.10.10"), (Ip4Address)Ip4Address.valueOf((String)"10.10.10.10"), (Ip4Address)Ip4Address.valueOf((String)"255.255.255.255"));
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testIsOpaqueEnabled() throws Exception {
        this.result2 = OspfUtil.isOpaqueEnabled((int)2);
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testisIsOpaqueEnabled() throws Exception {
        this.result2 = OspfUtil.isOpaqueEnabled((int)2);
        Assert.assertThat((Object)this.result2, (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testReadLsaHeader() throws Exception {
        byte[] header = new byte[]{0, 10, 2, 1, 7, 7, 7, 7, 7, 7, 7, 7, -128, 0, 0, 2, 46, -126, 0, 48, 0, 0, 0, 2, 1, 1, 1, 1, 10, 10, 10, 7, 1, 0, 0, 10, 10, 10, 10, 0, -1, -1, -1, 0, 3, 0, 0, 10, 0, 10, 66, 10, 1, 0, 0, 1, 7, 7, 7, 7, -128, 0, 0, 1, -64, 79, 0, 116, 0, 1, 0, 4, 0, 0, 0, 0, 0, 2, 0, 84, 0, 1, 0, 1, 1, 0, 0, 0, 0, 2, 0, 4, 10, 10, 10, 0, 0, 5, 0, 4, 0, 0, 0, 0, 0, 6, 0, 4, 73, -104, -106, -128, 0, 7, 0, 4, 73, -104, -106, -128, 0, 8, 0, 32, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 73, -104, -106, -128, 0, 9, 0, 4, 0, 0, 0, 0};
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])header);
        this.lsaHeader = OspfUtil.readLsaHeader((ChannelBuffer)this.channelBuffer);
        Assert.assertThat((Object)this.lsaHeader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testReadreadLsaHeader() throws Exception {
        byte[] header = new byte[]{0, 2, 2, 1, -64, -88, -86, 3, -64, -88, -86, 3, -128, 0, 0, 1, 58, -100, 0, 48};
        this.channelBuffer = ChannelBuffers.copiedBuffer((byte[])header);
        this.lsaHeader = OspfUtil.readLsaHeader((ChannelBuffer)this.channelBuffer);
        Assert.assertThat((Object)this.lsaHeader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

