/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.onlab.packet.IpAddress;
import org.onlab.util.Identifier;

public final class BgpId
extends Identifier<IpAddress> {
    private static final String SCHEME = "l3";
    private static final long UNKNOWN = 0L;

    public BgpId(IpAddress ipAddress) {
        super((Object)ipAddress);
    }

    public static BgpId bgpId(IpAddress ipAddress) {
        return new BgpId(ipAddress);
    }

    public IpAddress ipAddress() {
        return (IpAddress)this.identifier;
    }

    public static BgpId bgpId(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return new BgpId(IpAddress.valueOf((String)uri.getSchemeSpecificPart()));
    }

    public static URI uri(BgpId bgpId) {
        return BgpId.uri(bgpId.ipAddress());
    }

    public static URI uri(IpAddress ipAddress) {
        try {
            return new URI(SCHEME, ipAddress.toString(), null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

