/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.linkstate;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpNodeLSIdentifier
implements Comparable<Object> {
    private static final Logger log = LoggerFactory.getLogger(BgpNodeLSIdentifier.class);
    private NodeDescriptors nodeDescriptors;

    public BgpNodeLSIdentifier() {
        this.nodeDescriptors = null;
    }

    public BgpNodeLSIdentifier(NodeDescriptors nodeDescriptors) {
        this.nodeDescriptors = nodeDescriptors;
    }

    public static BgpNodeLSIdentifier parseLocalNodeDescriptors(ChannelBuffer cb, byte protocolId) throws BgpParseException {
        log.debug("parse Local node descriptor");
        ChannelBuffer tempBuf = cb.copy();
        short type = cb.readShort();
        short length = cb.readShort();
        if (cb.readableBytes() < length) {
            throw new BgpParseException(3, 9, tempBuf.readBytes(cb.readableBytes() + 4));
        }
        NodeDescriptors nodeDescriptors = new NodeDescriptors();
        ChannelBuffer tempCb = cb.readBytes((int)length);
        if (type != 256) {
            throw new BgpParseException(3, 1, null);
        }
        nodeDescriptors = NodeDescriptors.read(tempCb, length, type, protocolId);
        return new BgpNodeLSIdentifier(nodeDescriptors);
    }

    public NodeDescriptors getNodedescriptors() {
        return this.nodeDescriptors;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpNodeLSIdentifier) {
            BgpNodeLSIdentifier other = (BgpNodeLSIdentifier)obj;
            return Objects.equals(this.nodeDescriptors, other.nodeDescriptors);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.nodeDescriptors);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("NodeDescriptors", (Object)this.nodeDescriptors).toString();
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.nodeDescriptors.compareTo(((BgpNodeLSIdentifier)o).nodeDescriptors);
    }
}

