/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;

public class BgpEvpnEsi
implements Comparable<BgpEvpnEsi> {
    public static final int ESI_LENGTH = 10;
    private byte[] ethernetSegmentidentifier;

    public BgpEvpnEsi() {
        this.ethernetSegmentidentifier = null;
    }

    public BgpEvpnEsi(byte[] ethernetSegmentidentifier) {
        this.ethernetSegmentidentifier = ethernetSegmentidentifier;
    }

    public static BgpEvpnEsi read(ChannelBuffer cb) {
        return new BgpEvpnEsi(cb.readBytes(10).array());
    }

    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeBytes(this.ethernetSegmentidentifier);
        return cb.writerIndex() - iLenStartIndex;
    }

    public byte[] getEthernetSegmentidentifier() {
        return this.ethernetSegmentidentifier;
    }

    public int hashCode() {
        return Arrays.hashCode(this.ethernetSegmentidentifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpEvpnEsi) {
            BgpEvpnEsi that = (BgpEvpnEsi)obj;
            return Arrays.equals(this.ethernetSegmentidentifier, that.ethernetSegmentidentifier);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ethernetSegmentidentifier", (Object)this.ethernetSegmentidentifier).toString();
    }

    @Override
    public int compareTo(BgpEvpnEsi rd) {
        return 0;
    }
}

