/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpFsActionReDirect;
import org.onosproject.bgpio.types.BgpFsActionTrafficAction;
import org.onosproject.bgpio.types.BgpFsActionTrafficMarking;
import org.onosproject.bgpio.types.BgpFsActionTrafficRate;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.RouteTarget;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpExtendedCommunity
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpExtendedCommunity.class);
    public static final short TYPE = 16;
    public static final byte FLAGS = -64;
    private List<BgpValueType> fsActionTlv;

    public BgpExtendedCommunity(List<BgpValueType> fsActionTlv) {
        this.fsActionTlv = fsActionTlv;
    }

    public List<BgpValueType> fsActionTlv() {
        return this.fsActionTlv;
    }

    public static BgpExtendedCommunity read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempCb = cb.copy();
        Validation validation = Validation.parseAttributeHeader(cb);
        LinkedList<BgpValueType> fsActionTlvs = new LinkedList<BgpValueType>();
        if (cb.readableBytes() < validation.getLength()) {
            Validation.validateLen((byte)3, (byte)5, validation.getLength());
        }
        int len = validation.isShort() ? validation.getLength() + 4 : validation.getLength() + 3;
        ChannelBuffer data = tempCb.readBytes(len);
        if (validation.getFirstBit() && !validation.getSecondBit() && validation.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        ChannelBuffer tempBuf = cb.readBytes(validation.getLength());
        if (tempBuf.readableBytes() > 0) {
            BgpValueType fsActionTlv = null;
            ChannelBuffer actionBuf = tempBuf.readBytes(validation.getLength());
            while (actionBuf.readableBytes() > 0) {
                short actionType = actionBuf.readShort();
                switch (actionType) {
                    case 2: 
                    case 258: 
                    case 514: {
                        fsActionTlv = RouteTarget.read(actionType, actionBuf);
                        break;
                    }
                    case -32761: {
                        fsActionTlv = BgpFsActionTrafficAction.read(actionBuf);
                        break;
                    }
                    case -32759: {
                        fsActionTlv = BgpFsActionTrafficMarking.read(actionBuf);
                        break;
                    }
                    case -32762: {
                        fsActionTlv = BgpFsActionTrafficRate.read(actionBuf);
                        break;
                    }
                    case -32760: {
                        fsActionTlv = BgpFsActionReDirect.read(actionBuf);
                        break;
                    }
                    default: {
                        log.debug("Other type Not Supported:" + actionType);
                    }
                }
                if (fsActionTlv == null) continue;
                fsActionTlvs.add(fsActionTlv);
            }
        }
        return new BgpExtendedCommunity(fsActionTlvs);
    }

    @Override
    public short getType() {
        return 16;
    }

    public int hashCode() {
        return Objects.hash(this.fsActionTlv);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpExtendedCommunity) {
            BgpExtendedCommunity other = (BgpExtendedCommunity)obj;
            return Objects.equals(this.fsActionTlv, other.fsActionTlv);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("fsActionTlv", this.fsActionTlv).toString();
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        ListIterator<BgpValueType> listIterator = this.fsActionTlv().listIterator();
        cb.writeByte(-64);
        cb.writeByte((int)this.getType());
        int iActionLenIndex = cb.writerIndex();
        cb.writeByte(0);
        while (listIterator.hasNext()) {
            BgpValueType fsTlv = listIterator.next();
            if (fsTlv.getType() == 2 || fsTlv.getType() == 258 || fsTlv.getType() == 514) {
                RouteTarget routeTarget = (RouteTarget)fsTlv;
                routeTarget.write(cb);
                continue;
            }
            if (fsTlv.getType() == -32761) {
                BgpFsActionTrafficAction trafficAction = (BgpFsActionTrafficAction)fsTlv;
                trafficAction.write(cb);
                continue;
            }
            if (fsTlv.getType() == -32759) {
                BgpFsActionTrafficMarking trafficMarking = (BgpFsActionTrafficMarking)fsTlv;
                trafficMarking.write(cb);
                continue;
            }
            if (fsTlv.getType() == -32762) {
                BgpFsActionTrafficRate trafficRate = (BgpFsActionTrafficRate)fsTlv;
                trafficRate.write(cb);
                continue;
            }
            if (fsTlv.getType() != -32760) continue;
            BgpFsActionReDirect trafficRedirect = (BgpFsActionReDirect)fsTlv;
            trafficRedirect.write(cb);
        }
        int fsActionLen = cb.writerIndex() - iActionLenIndex;
        cb.setByte(iActionLenIndex, (int)((byte)(fsActionLen - 1)));
        return cb.writerIndex() - iLenStartIndex;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

