/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;

public class BgpFsActionTrafficRate
implements BgpValueType {
    public static final short TYPE = -32762;
    private short asn;
    private float rate;

    public BgpFsActionTrafficRate(short asn, float rate) {
        this.asn = asn;
        this.rate = rate;
    }

    @Override
    public short getType() {
        return -32762;
    }

    public int hashCode() {
        return Objects.hash(this.asn, Float.valueOf(this.rate));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpFsActionTrafficRate) {
            BgpFsActionTrafficRate other = (BgpFsActionTrafficRate)obj;
            return Objects.equals(this.asn, other.asn) && Objects.equals(Float.valueOf(this.rate), Float.valueOf(other.rate));
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort(-32762);
        cb.writeShort((int)this.asn);
        cb.writeFloat(this.rate);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static BgpFsActionTrafficRate read(ChannelBuffer cb) throws BgpParseException {
        short asn = cb.readShort();
        float rate = cb.readFloat();
        return new BgpFsActionTrafficRate(asn, rate);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("TYPE", -32762).add("asn", (int)this.asn).add("rate", this.rate).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

