/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpHeader {
    private static final Logger log = LoggerFactory.getLogger(BgpHeader.class);
    public static final int MARKER_LENGTH = 16;
    public static final short DEFAULT_HEADER_LENGTH = 19;
    private byte[] marker;
    private byte type;
    private short length;

    public BgpHeader() {
        this.marker = null;
        this.length = 0;
        this.type = 0;
    }

    public BgpHeader(byte[] marker, short length, byte type) {
        this.marker = marker;
        this.length = length;
        this.type = type;
    }

    public void setMarker(byte[] value) {
        this.marker = value;
    }

    public void setType(byte value) {
        this.type = value;
    }

    public void setLength(short value) {
        this.length = value;
    }

    public short getLength() {
        return this.length;
    }

    public byte[] getMarker() {
        return this.marker;
    }

    public byte getType() {
        return this.type;
    }

    public int write(ChannelBuffer cb) {
        cb.writeBytes(this.getMarker(), 0, 16);
        int headerLenIndex = cb.writerIndex();
        cb.writeShort(0);
        cb.writeByte((int)this.type);
        return headerLenIndex;
    }

    public static BgpHeader read(ChannelBuffer cb) {
        byte[] marker = new byte[16];
        cb.readBytes(marker, 0, 16);
        short length = cb.readShort();
        byte type = cb.readByte();
        return new BgpHeader(marker, length, type);
    }
}

