/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.types.BgpValueType;

public class BgpLSIdentifierTlv
implements BgpValueType {
    public static final short TYPE = 513;
    public static final short LENGTH = 4;
    private final int bgpLsIdentifier;

    public BgpLSIdentifierTlv(int bgpLsIdentifier) {
        this.bgpLsIdentifier = bgpLsIdentifier;
    }

    public static BgpLSIdentifierTlv of(int bgpLsIdentifier) {
        return new BgpLSIdentifierTlv(bgpLsIdentifier);
    }

    public int getBgpLsIdentifier() {
        return this.bgpLsIdentifier;
    }

    public int hashCode() {
        return Objects.hash(this.bgpLsIdentifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLSIdentifierTlv) {
            BgpLSIdentifierTlv other = (BgpLSIdentifierTlv)obj;
            return Objects.equals(this.bgpLsIdentifier, other.bgpLsIdentifier);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(513);
        c.writeShort(4);
        c.writeInt(this.bgpLsIdentifier);
        return c.writerIndex() - iLenStartIndex;
    }

    public static BgpLSIdentifierTlv read(ChannelBuffer cb) {
        return BgpLSIdentifierTlv.of(cb.readInt());
    }

    @Override
    public short getType() {
        return 513;
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return Integer.valueOf(this.bgpLsIdentifier).compareTo(((BgpLSIdentifierTlv)o).bgpLsIdentifier);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 513).add("Length", 4).add("Value", this.bgpLsIdentifier).toString();
    }
}

