/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.types.BgpValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourOctetAsNumCapabilityTlv
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(FourOctetAsNumCapabilityTlv.class);
    public static final byte TYPE = 65;
    public static final byte LENGTH = 4;
    private final int rawValue;

    public FourOctetAsNumCapabilityTlv(int rawValue) {
        this.rawValue = rawValue;
    }

    public static FourOctetAsNumCapabilityTlv of(int raw) {
        return new FourOctetAsNumCapabilityTlv(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public short getType() {
        return 65;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FourOctetAsNumCapabilityTlv) {
            FourOctetAsNumCapabilityTlv other = (FourOctetAsNumCapabilityTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(65);
        cb.writeByte(4);
        cb.writeInt(this.rawValue);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static FourOctetAsNumCapabilityTlv read(ChannelBuffer cb) {
        return FourOctetAsNumCapabilityTlv.of(cb.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 65).add("Length", 4).add("Value", this.rawValue).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

