/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.protocol.IgpRouterId;
import org.onosproject.bgpio.types.BgpValueType;

public class IsIsNonPseudonode
implements IgpRouterId,
BgpValueType {
    public static final short TYPE = 515;
    public static final short LENGTH = 6;
    private final byte[] isoNodeID;

    public IsIsNonPseudonode(byte[] isoNodeID) {
        this.isoNodeID = Arrays.copyOf(isoNodeID, isoNodeID.length);
    }

    public static IsIsNonPseudonode of(byte[] isoNodeID) {
        return new IsIsNonPseudonode(isoNodeID);
    }

    public byte[] getIsoNodeId() {
        return this.isoNodeID;
    }

    public int hashCode() {
        return Arrays.hashCode(this.isoNodeID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IsIsNonPseudonode) {
            IsIsNonPseudonode other = (IsIsNonPseudonode)obj;
            return Arrays.equals(this.isoNodeID, other.isoNodeID);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(515);
        c.writeShort(6);
        c.writeBytes(this.isoNodeID);
        return c.writerIndex() - iLenStartIndex;
    }

    public static IsIsNonPseudonode read(ChannelBuffer cb) {
        byte[] isoNodeID = new byte[6];
        cb.readBytes(isoNodeID);
        return IsIsNonPseudonode.of(isoNodeID);
    }

    @Override
    public short getType() {
        return 515;
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        ByteBuffer value1 = ByteBuffer.wrap(this.isoNodeID);
        ByteBuffer value2 = ByteBuffer.wrap(((IsIsNonPseudonode)o).isoNodeID);
        return value1.compareTo(value2);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 515).add("Length", 6).add("ISONodeID", (Object)this.isoNodeID).toString();
    }
}

