/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.types.BgpValueType;

public class LinkLocalRemoteIdentifiersTlv
implements BgpValueType {
    public static final short TYPE = 258;
    private static final int LENGTH = 8;
    private final int linkLocalIdentifer;
    private final int linkRemoteIdentifer;

    public LinkLocalRemoteIdentifiersTlv(int linkLocalIdentifer, int linkRemoteIdentifer) {
        this.linkLocalIdentifer = linkLocalIdentifer;
        this.linkRemoteIdentifer = linkRemoteIdentifer;
    }

    public int getLinkRemoteIdentifier() {
        return this.linkRemoteIdentifer;
    }

    public int getLinkLocalIdentifier() {
        return this.linkLocalIdentifer;
    }

    @Override
    public short getType() {
        return 258;
    }

    public int hashCode() {
        return Objects.hash(this.linkLocalIdentifer, this.linkRemoteIdentifer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkLocalRemoteIdentifiersTlv) {
            LinkLocalRemoteIdentifiersTlv other = (LinkLocalRemoteIdentifiersTlv)obj;
            return Objects.equals(this.linkLocalIdentifer, other.linkLocalIdentifer) && Objects.equals(this.linkRemoteIdentifer, other.linkRemoteIdentifer);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort(258);
        cb.writeShort(8);
        cb.writeInt(this.linkLocalIdentifer);
        cb.writeInt(this.linkRemoteIdentifer);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static LinkLocalRemoteIdentifiersTlv read(ChannelBuffer cb) {
        int linkLocalIdentifer = cb.readInt();
        int linkRemoteIdentifer = cb.readInt();
        return LinkLocalRemoteIdentifiersTlv.of(linkLocalIdentifer, linkRemoteIdentifer);
    }

    public static LinkLocalRemoteIdentifiersTlv of(int linkLocalIdentifer, int linkRemoteIdentifer) {
        return new LinkLocalRemoteIdentifiersTlv(linkLocalIdentifer, linkRemoteIdentifer);
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        int result = Integer.valueOf(this.linkLocalIdentifer).compareTo(((LinkLocalRemoteIdentifiersTlv)o).linkLocalIdentifer);
        if (result != 0) {
            return result;
        }
        return Integer.valueOf(this.linkRemoteIdentifer).compareTo(((LinkLocalRemoteIdentifiersTlv)o).linkRemoteIdentifer);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("TYPE", 258).add("LENGTH", 8).add("linkLocalIdentifer", this.linkLocalIdentifer).add("linkRemoteIdentifer", this.linkRemoteIdentifer).toString();
    }
}

