/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class Med
implements BgpValueType {
    public static final byte MED_TYPE = 4;
    public static final byte MED_MAX_LEN = 4;
    public static final byte FLAGS = -128;
    private int med;

    public Med(int med) {
        this.med = med;
    }

    public int med() {
        return this.med;
    }

    public static Med read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempCb = cb.copy();
        Validation parseFlags = Validation.parseAttributeHeader(cb);
        if (parseFlags.getLength() > 4 || cb.readableBytes() < parseFlags.getLength()) {
            Validation.validateLen((byte)3, (byte)5, parseFlags.getLength());
        }
        int len = parseFlags.isShort() ? parseFlags.getLength() + 4 : parseFlags.getLength() + 3;
        ChannelBuffer data = tempCb.readBytes(len);
        if (!parseFlags.getFirstBit() && parseFlags.getSecondBit() && parseFlags.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        int med = cb.readInt();
        return new Med(med);
    }

    @Override
    public short getType() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.med);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Med) {
            Med other = (Med)obj;
            return Objects.equals(this.med, other.med);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("med", this.med).toString();
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(-128);
        cb.writeByte((int)this.getType());
        cb.writeByte(4);
        cb.writeInt(this.med());
        return cb.writerIndex() - iLenStartIndex;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

