/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class Origin
implements BgpValueType {
    public static final byte ORIGIN_TYPE = 1;
    public static final byte ORIGIN_VALUE_LEN = 1;
    public static final byte FLAGS = 64;
    private boolean isOrigin = false;
    private byte origin;

    public Origin(byte origin) {
        this.origin = origin;
        this.isOrigin = true;
    }

    public boolean isOriginSet() {
        return this.isOrigin;
    }

    public OriginType origin() {
        if (this.origin == 0) {
            return OriginType.IGP;
        }
        if (this.origin == 1) {
            return OriginType.EGP;
        }
        return OriginType.INCOMPLETE;
    }

    public static Origin read(ChannelBuffer cb) throws BgpParseException {
        ChannelBuffer tempCb = cb.copy();
        Validation parseFlags = Validation.parseAttributeHeader(cb);
        int len = parseFlags.isShort() ? parseFlags.getLength() + 4 : parseFlags.getLength() + 3;
        ChannelBuffer data = tempCb.readBytes(len);
        if (parseFlags.getLength() > 1 || cb.readableBytes() < parseFlags.getLength()) {
            Validation.validateLen((byte)3, (byte)5, parseFlags.getLength());
        }
        if (parseFlags.getFirstBit() && !parseFlags.getSecondBit() && parseFlags.getThirdBit()) {
            throw new BgpParseException(3, 4, data);
        }
        byte originValue = cb.readByte();
        if (originValue != OriginType.INCOMPLETE.value && originValue != OriginType.IGP.value && originValue != OriginType.EGP.value) {
            throw new BgpParseException(3, 6, data);
        }
        return new Origin(originValue);
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeByte(64);
        cb.writeByte(1);
        cb.writeByte(1);
        cb.writeByte(this.origin().value);
        return cb.writerIndex() - iLenStartIndex;
    }

    public int hashCode() {
        return Objects.hash(this.origin);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Origin) {
            Origin other = (Origin)obj;
            return Objects.equals(this.origin, other.origin);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("origin", (int)this.origin).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    public static enum OriginType {
        IGP(0),
        EGP(1),
        INCOMPLETE(2);

        int value;

        private OriginType(int val) {
            this.value = val;
        }

        public byte getType() {
            return (byte)this.value;
        }
    }
}

