/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.types.BgpValueType;

public class RouteTarget
implements BgpValueType {
    private byte[] routeTarget;
    private short type;

    public RouteTarget() {
        this.type = 0;
        this.routeTarget = null;
    }

    public RouteTarget(short type, byte[] routeTarget) {
        this.type = type;
        this.routeTarget = routeTarget;
    }

    public static RouteTarget read(short type, ChannelBuffer cb) {
        return new RouteTarget(type, cb.readBytes(6).array());
    }

    public byte[] getRouteTarget() {
        return this.routeTarget;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouteTarget) {
            RouteTarget that = (RouteTarget)obj;
            if (this.type == that.type && Arrays.equals(this.routeTarget, that.routeTarget)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.type, Arrays.hashCode(this.routeTarget));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", (int)this.type).add("routeTarget", (Object)this.routeTarget).toString();
    }

    @Override
    public short getType() {
        return this.type;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort((int)this.type);
        cb.writeBytes(this.routeTarget);
        return cb.writerIndex() - iLenStartIndex;
    }

    @Override
    public int compareTo(Object rd) {
        return 0;
    }

    public static enum RouteTargetype {
        AS(2),
        IP(258),
        LARGEAS(514);

        short value;

        private RouteTargetype(short val) {
            this.value = val;
        }

        public short getType() {
            return this.value;
        }
    }
}

