/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class WideCommunityAttrHeader
implements BgpValueType {
    public static final short TYPE = 1;
    public static final short HEADER_LENGTH = 6;
    private byte flag;
    private byte hopCount;
    private short length;

    public WideCommunityAttrHeader(byte flag, byte hopCount, short length) {
        this.flag = flag;
        this.hopCount = hopCount;
        this.length = length;
    }

    public static WideCommunityAttrHeader of(byte flag, byte hopCount, short length) {
        return new WideCommunityAttrHeader(flag, hopCount, length);
    }

    public byte flag() {
        return this.flag;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public byte hopCount() {
        return this.hopCount;
    }

    public void setHopCount(byte hopCount) {
        this.hopCount = hopCount;
    }

    public short length() {
        return this.length;
    }

    public void setLength(short length) {
        this.length = length;
    }

    public int hashCode() {
        return Objects.hash(this.flag, this.hopCount, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WideCommunityAttrHeader) {
            WideCommunityAttrHeader other = (WideCommunityAttrHeader)obj;
            return Objects.equals(this.flag, other.flag) && Objects.equals(this.hopCount, other.hopCount) && Objects.equals(this.length, other.length);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(1);
        c.writeByte((int)this.flag);
        c.writeByte((int)this.hopCount);
        return c.writerIndex() - iLenStartIndex;
    }

    public static WideCommunityAttrHeader read(ChannelBuffer c) throws BgpParseException {
        if (c.readableBytes() < 6) {
            Validation.validateLen((byte)3, (byte)5, c.readableBytes());
        }
        short type = c.readShort();
        byte flag = c.readByte();
        byte hopCount = c.readByte();
        short length = c.readShort();
        return WideCommunityAttrHeader.of(flag, hopCount, length);
    }

    @Override
    public short getType() {
        return 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1).add("flag", (int)this.flag).add("hopCount", (int)this.hopCount).add("length", (int)this.length).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

