/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.attr.WideCommunity;

public class WideCommunityExcludeTarget
implements BgpValueType {
    public static final byte TYPE = 2;
    private List<BgpValueType> excludeTargetTlv;

    public WideCommunityExcludeTarget(List<BgpValueType> excludeTargetTlv) {
        this.excludeTargetTlv = excludeTargetTlv;
    }

    public static BgpValueType of(List<BgpValueType> excludeTargetTlv) {
        return new WideCommunityExcludeTarget(excludeTargetTlv);
    }

    public List<BgpValueType> excludeTargetTlv() {
        return this.excludeTargetTlv;
    }

    public void setExcludeTargetTlv(List<BgpValueType> excludeTargetTlv) {
        this.excludeTargetTlv = excludeTargetTlv;
    }

    public int hashCode() {
        return Objects.hash(this.excludeTargetTlv);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WideCommunityExcludeTarget) {
            WideCommunityExcludeTarget other = (WideCommunityExcludeTarget)obj;
            return Objects.equals(this.excludeTargetTlv, other.excludeTargetTlv);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        WideCommunity.encodeWideCommunityTlv(c, this.excludeTargetTlv());
        return c.writerIndex() - iLenStartIndex;
    }

    public static WideCommunityExcludeTarget read(ChannelBuffer c) throws BgpParseException {
        return new WideCommunityExcludeTarget(WideCommunity.decodeWideCommunityTlv(c));
    }

    @Override
    public short getType() {
        return 2;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("Type", 2).add("targetTlv", this.excludeTargetTlv).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

