/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class WideCommunityInteger
implements BgpValueType {
    public static final short TYPE = 4;
    private List<Integer> integer;

    public WideCommunityInteger(List<Integer> integer) {
        this.integer = integer;
    }

    public static WideCommunityInteger of(List<Integer> integer) {
        return new WideCommunityInteger(integer);
    }

    public List<Integer> integer() {
        return this.integer;
    }

    public void setInteger(List<Integer> integer) {
        this.integer = integer;
    }

    public int hashCode() {
        return Objects.hash(this.integer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WideCommunityInteger) {
            WideCommunityInteger other = (WideCommunityInteger)obj;
            return Objects.equals(this.integer, other.integer);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        Iterator<Integer> listIterator = this.integer.iterator();
        c.writeByte(4);
        int iLengthIndex = c.writerIndex();
        c.writeShort(0);
        while (listIterator.hasNext()) {
            Integer integer = listIterator.next();
            c.writeInt(integer.intValue());
        }
        int length = c.writerIndex() - iLengthIndex;
        c.setShort(iLengthIndex, (int)((short)(length - 2)));
        return c.writerIndex() - iLenStartIndex;
    }

    public static WideCommunityInteger read(ChannelBuffer c) throws BgpParseException {
        short length;
        ArrayList<Integer> integer = new ArrayList<Integer>();
        if (c.readableBytes() < 2) {
            Validation.validateLen((byte)3, (byte)5, c.readableBytes());
        }
        if ((length = c.readShort()) == 0) {
            return new WideCommunityInteger(integer);
        }
        if (c.readableBytes() < length) {
            Validation.validateLen((byte)3, (byte)5, c.readableBytes());
        }
        while (c.readableBytes() > 0) {
            if (c.readableBytes() < 4) {
                Validation.validateLen((byte)3, (byte)5, c.readableBytes());
            }
            integer.add(c.readInt());
        }
        return new WideCommunityInteger(integer);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("integer", this.integer).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public short getType() {
        return 0;
    }
}

