/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpAttrNodeName
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpAttrNodeName.class);
    public static final int ATTRNODE_NAME = 1026;
    private byte[] nodeName;

    public BgpAttrNodeName(byte[] nodeName) {
        this.nodeName = Arrays.copyOf(nodeName, nodeName.length);
    }

    public static BgpAttrNodeName of(byte[] nodeName) {
        return new BgpAttrNodeName(nodeName);
    }

    public static BgpAttrNodeName read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        byte[] nodeName = new byte[lsAttrLength];
        cb.readBytes(nodeName);
        log.debug("LS attribute node name read");
        return BgpAttrNodeName.of(nodeName);
    }

    public byte[] attrNodeName() {
        return this.nodeName;
    }

    @Override
    public short getType() {
        return 1026;
    }

    public int hashCode() {
        return Arrays.hashCode(this.nodeName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpAttrNodeName) {
            BgpAttrNodeName other = (BgpAttrNodeName)obj;
            return Arrays.equals(this.nodeName, other.nodeName);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("nodeName", (Object)this.nodeName).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

