/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.Ip6Address;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpAttrRouterIdV6
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpAttrRouterIdV6.class);
    private final short sType;
    private final Ip6Address ip6RouterId;

    private BgpAttrRouterIdV6(Ip6Address ip6RouterId, short sType) {
        this.ip6RouterId = ip6RouterId;
        this.sType = sType;
    }

    public static BgpAttrRouterIdV6 of(Ip6Address ip6RouterId, short sType) {
        return new BgpAttrRouterIdV6(ip6RouterId, sType);
    }

    public static BgpAttrRouterIdV6 read(ChannelBuffer cb, short sType) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 16 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        byte[] ipBytes = new byte[lsAttrLength];
        cb.readBytes(ipBytes);
        Ip6Address ip6RouterId = Ip6Address.valueOf((byte[])ipBytes);
        return BgpAttrRouterIdV6.of(ip6RouterId, sType);
    }

    public Ip6Address attrRouterId() {
        return this.ip6RouterId;
    }

    @Override
    public short getType() {
        return this.sType;
    }

    public int hashCode() {
        return Objects.hash(this.ip6RouterId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpAttrRouterIdV6) {
            BgpAttrRouterIdV6 other = (BgpAttrRouterIdV6)obj;
            return Objects.equals(this.ip6RouterId, other.ip6RouterId);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("ip6RouterId", (Object)this.ip6RouterId).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

