/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpLinkAttrName
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpLinkAttrName.class);
    public static final int ATTRLINK_NAME = 1098;
    private byte[] linkName;

    public BgpLinkAttrName(byte[] linkName) {
        this.linkName = Arrays.copyOf(linkName, linkName.length);
    }

    public static BgpLinkAttrName of(byte[] linkName) {
        return new BgpLinkAttrName(linkName);
    }

    public static BgpLinkAttrName read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        byte[] linkName = new byte[lsAttrLength];
        cb.readBytes(linkName);
        return BgpLinkAttrName.of(linkName);
    }

    public byte[] attrLinkName() {
        return this.linkName;
    }

    @Override
    public short getType() {
        return 1098;
    }

    public int hashCode() {
        return Arrays.hashCode(this.linkName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrName) {
            BgpLinkAttrName other = (BgpLinkAttrName)obj;
            return Arrays.equals(this.linkName, other.linkName);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("linkName", (Object)this.linkName).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

