/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public final class BgpLinkAttrProtectionType
implements BgpValueType {
    public static final int ATTRLINK_PROTECTIONTYPE = 1093;
    public static final int LINK_PROTECTION_LEN = 2;
    private byte linkProtectionType;

    public BgpLinkAttrProtectionType(byte linkProtectionType) {
        this.linkProtectionType = linkProtectionType;
    }

    public static BgpLinkAttrProtectionType of(byte linkProtectionType) {
        return new BgpLinkAttrProtectionType(linkProtectionType);
    }

    public static BgpLinkAttrProtectionType read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 2 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        byte linkProtectionType = cb.readByte();
        byte reserved = cb.readByte();
        return BgpLinkAttrProtectionType.of(linkProtectionType);
    }

    public ProtectionType protectionType() throws BgpParseException {
        switch (this.linkProtectionType) {
            case 1: {
                return ProtectionType.EXTRA_TRAFFIC;
            }
            case 2: {
                return ProtectionType.UNPROTECTED;
            }
            case 4: {
                return ProtectionType.SHARED;
            }
            case 8: {
                return ProtectionType.DEDICATED_ONE_ISTO_ONE;
            }
            case 16: {
                return ProtectionType.DEDICATED_ONE_PLUS_ONE;
            }
            case 32: {
                return ProtectionType.ENHANCED;
            }
            case 64: {
                return ProtectionType.RESERVED;
            }
        }
        throw new BgpParseException("Got another type " + this.linkProtectionType);
    }

    @Override
    public short getType() {
        return 1093;
    }

    public int hashCode() {
        return Objects.hash(this.linkProtectionType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrProtectionType) {
            BgpLinkAttrProtectionType other = (BgpLinkAttrProtectionType)obj;
            return Objects.equals(this.linkProtectionType, other.linkProtectionType);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("linkProtectionType", (int)this.linkProtectionType).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    public static enum ProtectionType {
        EXTRA_TRAFFIC(1),
        UNPROTECTED(2),
        SHARED(4),
        DEDICATED_ONE_ISTO_ONE(8),
        DEDICATED_ONE_PLUS_ONE(16),
        ENHANCED(32),
        RESERVED(64);

        int value;

        private ProtectionType(int val) {
            this.value = val;
        }

        public byte type() {
            return (byte)this.value;
        }
    }
}

