/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;

public class BgpLinkAttrSrlg
implements BgpValueType {
    public static final short ATTRNODE_SRLG = 1097;
    public static final short SIZE = 4;
    private List<Integer> sRlg = new ArrayList<Integer>();

    public BgpLinkAttrSrlg(List<Integer> sRlg) {
        this.sRlg = sRlg;
    }

    public static BgpLinkAttrSrlg of(ArrayList<Integer> sRlg) {
        return new BgpLinkAttrSrlg(sRlg);
    }

    public static BgpLinkAttrSrlg read(ChannelBuffer cb) throws BgpParseException {
        ArrayList<Integer> sRlg = new ArrayList<Integer>();
        short lsAttrLength = cb.readShort();
        int len = lsAttrLength / 4;
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        for (int i = 0; i < len; ++i) {
            int tempSrlg = cb.readInt();
            sRlg.add(new Integer(tempSrlg));
        }
        return BgpLinkAttrSrlg.of(sRlg);
    }

    public List<Integer> attrSrlg() {
        return this.sRlg;
    }

    @Override
    public short getType() {
        return 1097;
    }

    public int hashCode() {
        return Objects.hash(this.sRlg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrSrlg) {
            BgpLinkAttrSrlg other = (BgpLinkAttrSrlg)obj;
            return Objects.equals(this.sRlg, other.sRlg);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("sRlg", this.sRlg).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

