/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpLinkAttrTeDefaultMetric
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpLinkAttrTeDefaultMetric.class);
    public static final int ATTRLINK_TEDEFAULTMETRIC = 1092;
    public static final int TE_DATA_LEN = 4;
    private int linkTeMetric;

    public BgpLinkAttrTeDefaultMetric(int linkTeMetric) {
        this.linkTeMetric = linkTeMetric;
    }

    public static BgpLinkAttrTeDefaultMetric of(int linkTeMetric) {
        return new BgpLinkAttrTeDefaultMetric(linkTeMetric);
    }

    public static BgpLinkAttrTeDefaultMetric read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        if (lsAttrLength != 4 || cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        int linkTeMetric = cb.readInt();
        return new BgpLinkAttrTeDefaultMetric(linkTeMetric);
    }

    public int attrLinkDefTeMetric() {
        return this.linkTeMetric;
    }

    @Override
    public short getType() {
        return 1092;
    }

    public int hashCode() {
        return Objects.hash(this.linkTeMetric);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpLinkAttrTeDefaultMetric) {
            BgpLinkAttrTeDefaultMetric other = (BgpLinkAttrTeDefaultMetric)obj;
            return Objects.equals(this.linkTeMetric, other.linkTeMetric);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("linkTEMetric", this.linkTeMetric).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

