/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpPrefixAttrOpaqueData
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(BgpPrefixAttrOpaqueData.class);
    public static final int ATTR_PREFIX_OPAQUEDATA = 1157;
    private final byte[] opaquePrefixAttribute;

    public BgpPrefixAttrOpaqueData(byte[] opaquePrefixAttribute) {
        this.opaquePrefixAttribute = Arrays.copyOf(opaquePrefixAttribute, opaquePrefixAttribute.length);
    }

    public static BgpPrefixAttrOpaqueData of(byte[] opaquePrefixAttribute) {
        return new BgpPrefixAttrOpaqueData(opaquePrefixAttribute);
    }

    public static BgpPrefixAttrOpaqueData read(ChannelBuffer cb) throws BgpParseException {
        short lsAttrLength = cb.readShort();
        byte[] opaquePrefixAttribute = new byte[lsAttrLength];
        if (cb.readableBytes() < lsAttrLength) {
            Validation.validateLen((byte)3, (byte)5, lsAttrLength);
        }
        cb.readBytes(opaquePrefixAttribute);
        return BgpPrefixAttrOpaqueData.of(opaquePrefixAttribute);
    }

    public byte[] getOpaquePrefixAttribute() {
        return this.opaquePrefixAttribute;
    }

    @Override
    public short getType() {
        return 1157;
    }

    public int hashCode() {
        return Arrays.hashCode(this.opaquePrefixAttribute);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpPrefixAttrOpaqueData) {
            BgpPrefixAttrOpaqueData other = (BgpPrefixAttrOpaqueData)obj;
            return Arrays.equals(this.opaquePrefixAttribute, other.opaquePrefixAttribute);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer cb) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("opaquePrefixAttribute", (Object)this.getOpaquePrefixAttribute()).toString();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }
}

