/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types.attr;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onlab.packet.IpAddress;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.WideCommunityAttrHeader;
import org.onosproject.bgpio.types.WideCommunityExcludeTarget;
import org.onosproject.bgpio.types.WideCommunityInteger;
import org.onosproject.bgpio.types.WideCommunityIpV4Neighbour;
import org.onosproject.bgpio.types.WideCommunityParameter;
import org.onosproject.bgpio.types.WideCommunityTarget;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WideCommunity
implements BgpValueType {
    private static final Logger log = LoggerFactory.getLogger(WideCommunity.class);
    public static final byte TYPE = -127;
    public static final short LENGTH = 4;
    public static final byte TYPE_LENGTH_SIZE = 3;
    public static final byte FLAGS = -112;
    private WideCommunityAttrHeader wideCommunityHeader;
    private int community;
    private int localAsn;
    private int contextAsn;
    private WideCommunityTarget target;
    private WideCommunityExcludeTarget excludeTarget;
    private WideCommunityParameter parameter;

    public WideCommunity(WideCommunityAttrHeader wideCommunityHeader, int community, int localAsn, int contextAsn, WideCommunityTarget target, WideCommunityExcludeTarget excludeTarget, WideCommunityParameter parameter) {
        this.wideCommunityHeader = wideCommunityHeader;
        this.community = community;
        this.localAsn = localAsn;
        this.contextAsn = contextAsn;
        this.target = target;
        this.excludeTarget = excludeTarget;
        this.parameter = parameter;
    }

    public static WideCommunity of(WideCommunityAttrHeader wideCommunityHeader, int community, int localAsn, int contextAsn, WideCommunityTarget target, WideCommunityExcludeTarget excludeTarget, WideCommunityParameter parameter) {
        return new WideCommunity(wideCommunityHeader, community, localAsn, contextAsn, target, excludeTarget, parameter);
    }

    public int community() {
        return this.community;
    }

    public void setCommunity(int community) {
        this.community = community;
    }

    public int localAsn() {
        return this.localAsn;
    }

    public void setLocalAsn(int localAsn) {
        this.localAsn = localAsn;
    }

    public int contextAsn() {
        return this.contextAsn;
    }

    public void setContextAsn(int contextAsn) {
        this.contextAsn = contextAsn;
    }

    public WideCommunityTarget target() {
        return this.target;
    }

    public void setTarget(WideCommunityTarget target) {
        this.target = target;
    }

    public WideCommunityExcludeTarget excludeTarget() {
        return this.excludeTarget;
    }

    public void setExcludeTarget(WideCommunityExcludeTarget excludeTarget) {
        this.excludeTarget = excludeTarget;
    }

    public WideCommunityParameter parameter() {
        return this.parameter;
    }

    public void setParameter(WideCommunityParameter parameter) {
        this.parameter = parameter;
    }

    public int hashCode() {
        return Objects.hash(this.wideCommunityHeader, this.community, this.localAsn, this.contextAsn, this.target, this.excludeTarget, this.parameter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WideCommunity) {
            WideCommunity other = (WideCommunity)obj;
            return Objects.equals(this.wideCommunityHeader, other.wideCommunityHeader) && Objects.equals(this.community, other.community) && Objects.equals(this.localAsn, other.localAsn) && Objects.equals(this.contextAsn, other.contextAsn) && Objects.equals(this.target, other.target) && Objects.equals(this.excludeTarget, other.excludeTarget) && Objects.equals(this.parameter, other.parameter);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int length;
        int iTargetLenIndex;
        int iLenStartIndex = c.writerIndex();
        c.writeByte(-112);
        c.writeByte(-127);
        int iLengthIndex = c.writerIndex();
        c.writeShort(0);
        this.wideCommunityHeader.write(c);
        int iComLengthIndex = c.writerIndex();
        c.writeShort(0);
        c.writeInt(this.community);
        c.writeInt(this.localAsn);
        c.writeInt(this.contextAsn);
        if (this.target() != null) {
            c.writeByte(1);
            iTargetLenIndex = c.writerIndex();
            c.writeShort(0);
            this.target.write(c);
            length = c.writerIndex() - iTargetLenIndex;
            c.setShort(iTargetLenIndex, (int)((short)(length - 2)));
        }
        if (this.excludeTarget() != null) {
            c.writeByte(2);
            iTargetLenIndex = c.writerIndex();
            c.writeShort(0);
            this.excludeTarget.write(c);
            length = c.writerIndex() - iTargetLenIndex;
            c.setShort(iTargetLenIndex, (int)((short)(length - 2)));
        }
        if (this.parameter() != null) {
            c.writeByte(3);
            iTargetLenIndex = c.writerIndex();
            c.writeShort(0);
            this.parameter.write(c);
            length = c.writerIndex() - iTargetLenIndex;
            c.setShort(iTargetLenIndex, (int)((short)(length - 2)));
        }
        length = c.writerIndex() - iComLengthIndex;
        c.setShort(iComLengthIndex, (int)((short)(length - 2)));
        length = c.writerIndex() - iLengthIndex;
        c.setShort(iLengthIndex, (int)((short)(length - 2)));
        return c.writerIndex() - iLenStartIndex;
    }

    public static WideCommunity read(ChannelBuffer c) throws BgpParseException {
        WideCommunityTarget target = null;
        WideCommunityExcludeTarget excludeTarget = null;
        WideCommunityParameter parameter = null;
        short length = c.readShort();
        if (c.readableBytes() < length) {
            Validation.validateLen((byte)3, (byte)5, length);
        }
        WideCommunityAttrHeader wideCommunityHeader = WideCommunityAttrHeader.read(c);
        if (c.readableBytes() < 12 || c.readableBytes() < wideCommunityHeader.length()) {
            Validation.validateLen((byte)3, (byte)5, length);
        }
        int community = c.readInt();
        int localAsn = c.readInt();
        int contextAsn = c.readInt();
        while (c.readableBytes() > 0) {
            if (c.readableBytes() < 3) {
                Validation.validateLen((byte)3, (byte)5, c.readableBytes());
            }
            byte type = c.readByte();
            length = c.readShort();
            if (c.readableBytes() < length) {
                Validation.validateLen((byte)3, (byte)5, c.readableBytes());
            }
            if (type == 1) {
                target = WideCommunityTarget.read(c);
                continue;
            }
            if (type == 2) {
                excludeTarget = WideCommunityExcludeTarget.read(c);
                continue;
            }
            if (type != 3) continue;
            parameter = WideCommunityParameter.read(c);
        }
        return new WideCommunity(wideCommunityHeader, community, localAsn, contextAsn, target, excludeTarget, parameter);
    }

    public static void encodeWideCommunityTlv(ChannelBuffer c, List<BgpValueType> targetTlv) {
        List<BgpValueType> target = targetTlv;
        if (target == null) {
            log.debug("target is null");
            return;
        }
        for (BgpValueType attr : targetTlv) {
            if (attr instanceof WideCommunityIpV4Neighbour) {
                WideCommunityIpV4Neighbour ipv4Neig = (WideCommunityIpV4Neighbour)attr;
                ipv4Neig.write(c);
                continue;
            }
            if (!(attr instanceof WideCommunityInteger)) continue;
            WideCommunityInteger integer = (WideCommunityInteger)attr;
            integer.write(c);
        }
    }

    public static List<BgpValueType> decodeWideCommunityTlv(ChannelBuffer c) throws BgpParseException {
        ArrayList<BgpValueType> targetTlv = new ArrayList<BgpValueType>();
        while (c.readableBytes() > 0) {
            ChannelBuffer tempBuf;
            if (c.readableBytes() < 3) {
                Validation.validateLen((byte)3, (byte)5, c.readableBytes());
            }
            byte atomType = c.readByte();
            short atomLength = c.readShort();
            if (c.readableBytes() < atomLength) {
                Validation.validateLen((byte)3, (byte)5, atomLength);
            }
            if (atomType == 8) {
                tempBuf = c.readBytes((int)atomLength);
                WideCommunityIpV4Neighbour wideCommAtom = new WideCommunityIpV4Neighbour();
                while (tempBuf.readableBytes() > 0) {
                    wideCommAtom.add(IpAddress.valueOf((int)tempBuf.readInt()), IpAddress.valueOf((int)tempBuf.readInt()));
                }
                targetTlv.add(wideCommAtom);
                continue;
            }
            if (atomType == 4) {
                tempBuf = c.readBytes((int)atomLength);
                ArrayList<Integer> integer = new ArrayList<Integer>();
                while (tempBuf.readableBytes() > 0) {
                    integer.add(tempBuf.readInt());
                }
                targetTlv.add(new WideCommunityInteger(integer));
                continue;
            }
            Validation.validateLen((byte)3, (byte)1, atomLength);
        }
        return targetTlv;
    }

    @Override
    public short getType() {
        return -127;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("FLAGS", -112).add("wideCommunityHeader", (Object)this.wideCommunityHeader).add("community", this.community).add("localAsn", this.localAsn).add("contextAsn", this.contextAsn).add("target", (Object)this.target).add("excludeTarget", (Object)this.excludeTarget).add("parameter", (Object)this.parameter).toString();
    }
}

