/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpPrefix;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpUpdateMsg;
import org.onosproject.bgpio.protocol.NlriType;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.ver4.BgpPathAttributes;
import org.onosproject.bgpio.types.AsPath;
import org.onosproject.bgpio.types.BgpHeader;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.LinkStateAttributes;
import org.onosproject.bgpio.types.Med;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.Origin;
import org.onosproject.bgpio.types.attr.BgpAttrNodeFlagBitTlv;
import org.onosproject.bgpio.types.attr.BgpAttrNodeIsIsAreaId;
import org.onosproject.bgpio.types.attr.BgpAttrNodeMultiTopologyId;
import org.onosproject.bgpio.types.attr.BgpAttrNodeName;
import org.onosproject.bgpio.types.attr.BgpAttrOpaqueNode;
import org.onosproject.bgpio.types.attr.BgpAttrRouterIdV4;
import org.onosproject.bgpio.types.attr.BgpLinkAttrIsIsAdminstGrp;
import org.onosproject.bgpio.types.attr.BgpLinkAttrMplsProtocolMask;
import org.onosproject.bgpio.types.attr.BgpLinkAttrOpaqLnkAttrib;
import org.onosproject.bgpio.types.attr.BgpLinkAttrProtectionType;
import org.onosproject.bgpio.types.attr.BgpLinkAttrSrlg;
import org.onosproject.bgpio.types.attr.BgpLinkAttrTeDefaultMetric;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrOpaqueData;
import org.onosproject.bgpio.types.attr.BgpPrefixAttrRouteTag;

public class BgpUpdateLinkStateAttrTest {
    @Test
    public void bgpUpdateMessageTest1() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -107, 2, 0, 4, 24, 10, 1, 1, 0, 122, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 15, 4, 4, 0, 4, -67, 89, 76, 98, 4, 71, 0, 3, 0, 0, 10};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)149));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        byte[] linkAttrbs = new byte[]{-128, 29, 15, 4, 4, 0, 4, -67, 89, 76, 98, 4, 71, 0, 3, 0, 0, 10};
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes(linkAttrbs);
        LinkStateAttributes obj = LinkStateAttributes.read((ChannelBuffer)cb);
        MatcherAssert.assertThat((Object)linkStateAttr.linkStateAttributes(), (Matcher)Is.is((Object)obj.linkStateAttributes()));
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
    }

    @Test
    public void bgpUpdateMessageTest2() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, 6, 0, 4, 22, 22, 22, 22};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)150));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath asPath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = asPath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        byte[] linkAttrbs = new byte[]{-128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, 6, 0, 4, 22, 22, 22, 22};
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes(linkAttrbs);
        LinkStateAttributes obj = LinkStateAttributes.read((ChannelBuffer)cb);
        MatcherAssert.assertThat((Object)linkStateAttr.linkStateAttributes(), (Matcher)Is.is((Object)obj.linkStateAttributes()));
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
    }

    @Test
    public void bgpUpdateMessageTest3() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, -125, 0, 4, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)150));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        byte[] linkAttrbs = new byte[]{-128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, -125, 0, 4, 0, 0, 0, 0};
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes(linkAttrbs);
        LinkStateAttributes obj = LinkStateAttributes.read((ChannelBuffer)cb);
        MatcherAssert.assertThat((Object)linkStateAttr.linkStateAttributes(), (Matcher)Is.is((Object)obj.linkStateAttributes()));
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
    }

    @Test
    public void bgpUpdateMessageTest4() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -104, 2, 0, 4, 24, 10, 1, 1, 0, 125, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 18, 4, 4, 0, 4, 21, 21, 21, 21, 4, 2, 0, 6, 55, 55, 53, 48, 45, 49};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)152));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        byte[] linkAttrbs = new byte[]{-128, 29, 18, 4, 4, 0, 4, 21, 21, 21, 21, 4, 2, 0, 6, 55, 55, 53, 48, 45, 49};
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes(linkAttrbs);
        LinkStateAttributes obj = LinkStateAttributes.read((ChannelBuffer)cb);
        ListIterator list = obj.linkStateAttributes().listIterator();
        ListIterator list2 = linkStateAttr.linkStateAttributes().listIterator();
        MatcherAssert.assertThat(list.next(), (Matcher)Is.is(list2.next()));
        MatcherAssert.assertThat((Object)((BgpAttrNodeName)list2.next()).attrNodeName(), (Matcher)Is.is((Object)((BgpAttrNodeName)list.next()).attrNodeName()));
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
    }

    @Test
    public void bgpUpdateMessageTest5() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -107, 2, 0, 4, 24, 10, 1, 1, 0, 122, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 15, 4, 4, 0, 4, -67, 89, 76, 98, 4, 3, 0, 3, 64, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)149));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        byte[] linkAttrbs = new byte[]{-128, 29, 15, 4, 4, 0, 4, -67, 89, 76, 98, 4, 3, 0, 3, 64, 1, 0};
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes(linkAttrbs);
        LinkStateAttributes obj = LinkStateAttributes.read((ChannelBuffer)cb);
        ListIterator list = obj.linkStateAttributes().listIterator();
        ListIterator list2 = linkStateAttr.linkStateAttributes().listIterator();
        MatcherAssert.assertThat(list.next(), (Matcher)Is.is(list2.next()));
        MatcherAssert.assertThat((Object)((BgpAttrNodeIsIsAreaId)list2.next()).attrNodeIsIsAreaId(), (Matcher)Is.is((Object)((BgpAttrNodeIsIsAreaId)list.next()).attrNodeIsIsAreaId()));
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
    }

    @Test
    public void bgpUpdateMessageTest6() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -94, 2, 0, 4, 24, 10, 1, 1, 0, -121, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 28, 4, 4, 0, 4, 21, 21, 21, 21, 4, 5, 0, 16, 1, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)162));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        byte[] linkAttrbs = new byte[]{-128, 29, 28, 4, 4, 0, 4, 21, 21, 21, 21, 4, 5, 0, 16, 1, 102, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes(linkAttrbs);
        LinkStateAttributes obj = LinkStateAttributes.read((ChannelBuffer)cb);
        MatcherAssert.assertThat((Object)linkStateAttr.linkStateAttributes(), (Matcher)Is.is((Object)obj.linkStateAttributes()));
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
    }

    @Test
    public void bgpUpdateMessageTest7() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 1, 7, 0, 4, 0, 0, 0, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)150));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        byte[] linkAttrbs = new byte[]{-128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 1, 7, 0, 4, 0, 0, 0, 2};
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes(linkAttrbs);
        LinkStateAttributes obj = LinkStateAttributes.read((ChannelBuffer)cb);
        ListIterator list = obj.linkStateAttributes().listIterator();
        ListIterator list2 = linkStateAttr.linkStateAttributes().listIterator();
        MatcherAssert.assertThat(list.next(), (Matcher)Is.is(list2.next()));
        MatcherAssert.assertThat((Object)((BgpAttrNodeMultiTopologyId)list2.next()).attrMultiTopologyId(), (Matcher)Is.is((Object)((BgpAttrNodeMultiTopologyId)list.next()).attrMultiTopologyId()));
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
    }

    @Test
    public void bgpUpdateMessageTest8() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, -127, 0, 4, 0, 0, 0, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)150));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        byte[] linkAttrbs = new byte[]{-128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, -127, 0, 4, 0, 0, 0, 1};
        ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
        cb.writeBytes(linkAttrbs);
        LinkStateAttributes obj = LinkStateAttributes.read((ChannelBuffer)cb);
        ListIterator list = obj.linkStateAttributes().listIterator();
        ListIterator list2 = linkStateAttr.linkStateAttributes().listIterator();
        MatcherAssert.assertThat(list.next(), (Matcher)Is.is(list2.next()));
        MatcherAssert.assertThat((Object)((BgpPrefixAttrRouteTag)list2.next()).getPfxRouteTag(), (Matcher)Is.is((Object)((BgpPrefixAttrRouteTag)list.next()).getPfxRouteTag()));
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
    }

    @Test
    public void bgpUpdateMessageTest9() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, 64, 0, 4, 0, 0, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)150));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        MatcherAssert.assertThat((Object)((BgpLinkAttrIsIsAdminstGrp)list.next()).linkAttrIsIsAdminGrp(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void bgpUpdateMessageTest10() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -109, 2, 0, 4, 24, 10, 1, 1, 0, 120, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 13, 4, 4, 0, 4, 21, 21, 21, 21, 4, 0, 0, 1, 32};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)147));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        BgpAttrNodeFlagBitTlv obj = new BgpAttrNodeFlagBitTlv(false, false, true, false);
        MatcherAssert.assertThat((Object)((BgpAttrNodeFlagBitTlv)list.next()).equals((Object)obj), (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpUpdateMessageTest11() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, 68, 0, 4, 0, 0, 0, 10};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)150));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        MatcherAssert.assertThat((Object)((BgpLinkAttrTeDefaultMetric)list.next()).attrLinkDefTeMetric(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void bgpUpdateMessageTest12() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, 1, 0, 4, 0, 0, 0, 10};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)150));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        byte[] opaqueNode = new byte[]{0, 0, 0, 10};
        MatcherAssert.assertThat((Object)((BgpAttrOpaqueNode)list.next()).attrOpaqueNode(), (Matcher)Is.is((Object)opaqueNode));
    }

    @Test
    public void bgpUpdateMessageTest13() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -108, 2, 0, 4, 24, 10, 1, 1, 0, 121, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 14, 4, 4, 0, 4, 21, 21, 21, 21, 4, 69, 0, 2, 16, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)148));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        MatcherAssert.assertThat((Object)((BgpLinkAttrProtectionType)list.next()).protectionType(), (Matcher)Is.is((Object)BgpLinkAttrProtectionType.ProtectionType.DEDICATED_ONE_PLUS_ONE));
    }

    @Test
    public void bgpUpdateMessageTest14() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -109, 2, 0, 4, 24, 10, 1, 1, 0, 120, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 13, 4, 4, 0, 4, 21, 21, 21, 21, 4, 70, 0, 1, -64};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)147));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        BgpLinkAttrMplsProtocolMask obj = new BgpLinkAttrMplsProtocolMask(true, true);
        MatcherAssert.assertThat((Object)((BgpLinkAttrMplsProtocolMask)list.next()).equals((Object)obj), (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpUpdateMessageTest15() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -102, 2, 0, 4, 24, 10, 1, 1, 0, 127, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 20, 4, 4, 0, 4, 21, 21, 21, 21, 4, 72, 0, 8, 0, 0, 0, 10, 0, 0, 0, 11};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)154));
        ListIterator listIterator1 = other.withdrawnRoutes().listIterator();
        byte[] prefix = new byte[]{10, 1, 1, 0};
        while (listIterator1.hasNext()) {
            IpPrefix testPrefixValue = (IpPrefix)listIterator1.next();
            MatcherAssert.assertThat((Object)testPrefixValue.prefixLength(), (Matcher)Is.is((Object)24));
            MatcherAssert.assertThat((Object)testPrefixValue.address().toOctets(), (Matcher)Is.is((Object)prefix));
        }
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        NlriType nlriType = NlriType.LINK;
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getIdentifier(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)testnlri.getNlriType(), (Matcher)Is.is((Object)nlriType));
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        ArrayList<Integer> attrSrlg = new ArrayList<Integer>();
        attrSrlg.add(10);
        attrSrlg.add(11);
        MatcherAssert.assertThat((Object)((BgpLinkAttrSrlg)list.next()).attrSrlg(), (Matcher)Is.is(attrSrlg));
    }

    @Test
    public void bgpUpdateMessageTest16() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -102, 2, 0, 4, 24, 10, 1, 1, 0, 127, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 20, 4, 4, 0, 4, 21, 21, 21, 21, 4, 73, 0, 8, 0, 0, 0, 10, 0, 0, 0, 11};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)154));
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        MatcherAssert.assertThat((Object)mpReach.mpReachNlriLen(), (Matcher)Is.is((Object)83));
        MatcherAssert.assertThat((Object)mpReach.getType(), (Matcher)Is.is((Object)14));
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        byte[] attrOpaqLnkAttrib = new byte[]{0, 0, 0, 10, 0, 0, 0, 11};
        MatcherAssert.assertThat((Object)((BgpLinkAttrOpaqLnkAttrib)list.next()).attrOpaqueLnk(), (Matcher)Is.is((Object)attrOpaqLnkAttrib));
    }

    @Test
    public void bgpUpdateMessageTest17() throws BgpParseException {
        byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -106, 2, 0, 4, 24, 10, 1, 1, 0, 123, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 83, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 70, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, -128, 29, 16, 4, 4, 0, 4, 21, 21, 21, 21, 4, -123, 0, 4, 10, 10, 10, 10};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(updateMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsg.class));
        BgpUpdateMsg other = (BgpUpdateMsg)message;
        byte[] marker = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        MatcherAssert.assertThat((Object)other.getHeader().getMarker(), (Matcher)Is.is((Object)marker));
        MatcherAssert.assertThat((Object)other.getHeader().getType(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)other.getHeader().getLength(), (Matcher)Is.is((Object)150));
        BgpValueType testPathAttribute = null;
        List pathAttributeList = new LinkedList();
        BgpPathAttributes pathAttribute = other.bgpPathAttributes();
        pathAttributeList = pathAttribute.pathAttributes();
        ListIterator listIterator = pathAttributeList.listIterator();
        Origin.OriginType originValue = Origin.OriginType.IGP;
        testPathAttribute = (BgpValueType)listIterator.next();
        Origin origin = (Origin)testPathAttribute;
        MatcherAssert.assertThat((Object)origin.origin(), (Matcher)Is.is((Object)originValue));
        testPathAttribute = (BgpValueType)listIterator.next();
        AsPath aspath = (AsPath)testPathAttribute;
        ListIterator listIterator2 = aspath.asPathSeq().listIterator();
        MatcherAssert.assertThat(listIterator2.next(), (Matcher)Is.is((Object)-535));
        testPathAttribute = (BgpValueType)listIterator.next();
        Med med = (Med)testPathAttribute;
        MatcherAssert.assertThat((Object)med.med(), (Matcher)Is.is((Object)0));
        testPathAttribute = (BgpValueType)listIterator.next();
        MpReachNlri mpReach = (MpReachNlri)testPathAttribute;
        List testMpReachNlri = new LinkedList();
        testMpReachNlri = mpReach.mpReachNlri();
        ListIterator list1 = testMpReachNlri.listIterator();
        BgpLSNlri testnlri = (BgpLSNlri)list1.next();
        BgpNodeLSNlriVer4.ProtocolType protocolId = BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO;
        MatcherAssert.assertThat((Object)testnlri.getProtocolId(), (Matcher)Is.is((Object)protocolId));
        testPathAttribute = (BgpValueType)listIterator.next();
        LinkStateAttributes linkStateAttr = (LinkStateAttributes)testPathAttribute;
        MatcherAssert.assertThat((Object)linkStateAttr.getType(), (Matcher)Is.is((Object)29));
        ListIterator list = linkStateAttr.linkStateAttributes().listIterator();
        byte[] ipBytes = new byte[]{21, 21, 21, 21};
        Ip4Address ip4RouterId = Ip4Address.valueOf((byte[])ipBytes);
        MatcherAssert.assertThat((Object)((BgpAttrRouterIdV4)list.next()).attrRouterId(), (Matcher)Is.is((Object)ip4RouterId));
        byte[] opaquePrefixAttr = new byte[]{10, 10, 10, 10};
        MatcherAssert.assertThat((Object)((BgpPrefixAttrOpaqueData)list.next()).getOpaquePrefixAttribute(), (Matcher)Is.is((Object)opaquePrefixAttr));
    }
}

