/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.types;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.ver4.BgpUpdateMsgVer4;
import org.onosproject.bgpio.types.BgpHeader;

public class MpUnReachNlriTest {
    @Test
    public void mpUnReachNlriTest() throws BgpParseException {
        byte[] flowSpecMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 43, 2, 0, 0, 0, 20, -112, 15, 0, 16, 0, 1, -123, 12, 2, 32, -64, -88, 7, 54, 3, -127, 103, 4, -127, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(flowSpecMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpUpdateMsgVer4.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testFsMsg = new byte[readLen];
        buf.readBytes(testFsMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testFsMsg, (Matcher)Is.is((Object)flowSpecMsg));
    }
}

