/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.grpc.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.util.Identifier;
import org.onosproject.net.DeviceId;

@Beta
public final class GrpcChannelId
extends Identifier<String> {
    private final DeviceId deviceId;
    private final String channelName;

    private GrpcChannelId(DeviceId deviceId, String channelName) {
        super((Object)(deviceId.toString() + ":" + channelName));
        Preconditions.checkNotNull((Object)deviceId, (Object)"device id must not be null");
        Preconditions.checkNotNull((Object)channelName, (Object)"channel name must not be null");
        Preconditions.checkArgument((!channelName.isEmpty() ? 1 : 0) != 0, (Object)"channel name must not be empty");
        this.deviceId = deviceId;
        this.channelName = channelName;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public String channelName() {
        return this.channelName;
    }

    public static GrpcChannelId of(DeviceId id, String channelName) {
        return new GrpcChannelId(id, channelName);
    }
}

