/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.grpc.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.util.Identifier;
import org.onosproject.grpc.api.GrpcChannelId;

@Beta
public final class GrpcServiceId
extends Identifier<String> {
    private final GrpcChannelId channelId;
    private final String serviceName;

    private GrpcServiceId(GrpcChannelId channelId, String serviceName) {
        super((Object)(channelId.toString() + ":" + serviceName));
        Preconditions.checkNotNull((Object)((Object)channelId), (Object)"channel id must not be null");
        Preconditions.checkNotNull((Object)serviceName, (Object)"service name must not be null");
        Preconditions.checkArgument((!serviceName.isEmpty() ? 1 : 0) != 0, (Object)"service name must not be empty");
        this.channelId = channelId;
        this.serviceName = serviceName;
    }

    public GrpcChannelId channelId() {
        return this.channelId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public static GrpcServiceId of(GrpcChannelId id, String serviceName) {
        return new GrpcServiceId(id, serviceName);
    }
}

