/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.grpc.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.util.Identifier;
import org.onosproject.grpc.api.GrpcServiceId;

@Beta
public final class GrpcStreamObserverId
extends Identifier<String> {
    private GrpcServiceId serviceId;
    private String streamName;

    private GrpcStreamObserverId(GrpcServiceId serviceId, String streamName) {
        super((Object)(serviceId.toString() + ":" + streamName));
        Preconditions.checkNotNull((Object)((Object)serviceId), (Object)"service id must not be null");
        Preconditions.checkNotNull((Object)streamName, (Object)"stream name must not be null");
        Preconditions.checkArgument((!streamName.isEmpty() ? 1 : 0) != 0, (Object)"stream name must not be empty");
        this.serviceId = serviceId;
        this.streamName = streamName;
    }

    public GrpcServiceId serviceId() {
        return this.serviceId;
    }

    public String streamName() {
        return this.streamName;
    }

    public static GrpcStreamObserverId of(GrpcServiceId id, String streamName) {
        return new GrpcStreamObserverId(id, streamName);
    }
}

