/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.ctl;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.ctl.LispRouter;
import org.onosproject.lisp.ctl.LispRouterAgent;
import org.onosproject.lisp.ctl.LispRouterId;
import org.onosproject.lisp.msg.protocols.LispEidRecord;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.net.Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLispRouter
implements LispRouter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DROP_MESSAGE_WARN = "Drop message {} destined to router {} as channel is closed.";
    private Channel channel;
    private String channelId;
    private boolean connected;
    private boolean subscribed;
    private LispRouterId routerId;
    private LispRouterAgent agent;
    private List<LispEidRecord> records;

    AbstractLispRouter(LispRouterId routerId) {
        this.routerId = routerId;
    }

    @Override
    public final String channelId() {
        return this.channelId;
    }

    @Override
    public final IpAddress routerId() {
        return (IpAddress)this.routerId.id();
    }

    @Override
    public final String stringId() {
        return this.routerId.toString();
    }

    @Override
    public final void setChannel(Channel channel) {
        this.channel = channel;
        SocketAddress address = channel.remoteAddress();
        if (address instanceof InetSocketAddress) {
            this.channelId = this.genChannelId((InetSocketAddress)address);
        }
    }

    @Override
    public final void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    public final boolean isSubscribed() {
        return this.subscribed;
    }

    @Override
    public final void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    @Override
    public final void setAgent(LispRouterAgent agent) {
        if (this.agent == null) {
            this.agent = agent;
        }
    }

    @Override
    public final Device.Type deviceType() {
        return Device.Type.ROUTER;
    }

    @Override
    public void sendMessage(LispMessage message) {
        if (this.channel.isOpen()) {
            this.channel.write((Object)message);
            this.agent.processDownstreamMessage(this.routerId, message);
        } else {
            this.log.warn(DROP_MESSAGE_WARN, (Object)message, (Object)this.routerId);
        }
    }

    @Override
    public void handleMessage(LispMessage message) {
        this.agent.processUpstreamMessage(this.routerId, message);
    }

    @Override
    public final boolean connectRouter() {
        this.setConnected(true);
        return this.agent.addConnectedRouter(this.routerId, this);
    }

    @Override
    public final void disconnectRouter() {
        this.setConnected(false);
        this.channel.close();
    }

    @Override
    public List<LispEidRecord> getEidRecords() {
        return this.records;
    }

    @Override
    public void setEidRecords(List<LispEidRecord> records) {
        this.records = ImmutableList.copyOf(records);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        String address = this.channel != null ? this.channel.remoteAddress().toString() : "?";
        String routerId = this.stringId() != null ? this.stringId() : "?";
        sb.append(" [");
        sb.append(address);
        sb.append(" routerId[");
        sb.append(routerId);
        sb.append("]]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractLispRouter that = (AbstractLispRouter)o;
        return Objects.equal((Object)this.channel, (Object)that.channel) && Objects.equal((Object)this.channelId, (Object)that.channelId) && Objects.equal((Object)this.connected, (Object)that.connected) && Objects.equal((Object)this.subscribed, (Object)that.subscribed) && Objects.equal((Object)((Object)this.routerId), (Object)((Object)that.routerId)) && Objects.equal((Object)this.agent, (Object)that.agent);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.channel, this.channelId, this.connected, this.subscribed, this.routerId, this.agent});
    }

    private String genChannelId(InetSocketAddress inetAddress) {
        StringBuilder sb = new StringBuilder();
        IpAddress ipAddress = IpAddress.valueOf((InetAddress)inetAddress.getAddress());
        if (ipAddress.isIp4()) {
            sb.append(ipAddress.toString());
            sb.append(":");
            sb.append(inetAddress.getPort());
        } else {
            sb.append("[");
            sb.append(ipAddress.toString());
            sb.append("]:");
            sb.append(inetAddress.getPort());
        }
        return sb.toString();
    }
}

