/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.protocols.LispRecord;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public abstract class AbstractLispRecord
implements LispRecord {
    protected final int recordTtl;
    protected final byte maskLength;
    protected final LispMapReplyAction action;
    protected final boolean authoritative;
    protected final short mapVersionNumber;
    protected final LispAfiAddress eidPrefixAfi;

    protected AbstractLispRecord(int recordTtl, byte maskLength, LispMapReplyAction action, boolean authoritative, short mapVersionNumber, LispAfiAddress eidPrefixAfi) {
        this.recordTtl = recordTtl;
        this.maskLength = maskLength;
        this.action = action;
        this.authoritative = authoritative;
        this.mapVersionNumber = mapVersionNumber;
        this.eidPrefixAfi = eidPrefixAfi;
    }

    @Override
    public int getRecordTtl() {
        return this.recordTtl;
    }

    @Override
    public byte getMaskLength() {
        return this.maskLength;
    }

    @Override
    public LispMapReplyAction getAction() {
        return this.action;
    }

    @Override
    public boolean isAuthoritative() {
        return this.authoritative;
    }

    @Override
    public short getMapVersionNumber() {
        return this.mapVersionNumber;
    }

    @Override
    public LispAfiAddress getEidPrefixAfi() {
        return this.eidPrefixAfi;
    }

    public static class AbstractRecordBuilder<T>
    implements LispRecord.RecordBuilder<T> {
        protected int recordTtl;
        protected byte maskLength;
        protected LispMapReplyAction action;
        protected boolean authoritative;
        protected short mapVersionNumber;
        protected LispAfiAddress eidPrefixAfi;

        @Override
        public T withRecordTtl(int recordTtl) {
            this.recordTtl = recordTtl;
            return (T)this;
        }

        @Override
        public T withMaskLength(byte maskLength) {
            this.maskLength = maskLength;
            return (T)this;
        }

        @Override
        public T withAction(LispMapReplyAction action) {
            this.action = action;
            return (T)this;
        }

        @Override
        public T withIsAuthoritative(boolean authoritative) {
            this.authoritative = authoritative;
            return (T)this;
        }

        @Override
        public T withMapVersionNumber(short mapVersionNumber) {
            this.mapVersionNumber = mapVersionNumber;
            return (T)this;
        }

        @Override
        public T withEidPrefixAfi(LispAfiAddress prefix) {
            this.eidPrefixAfi = prefix;
            return (T)this;
        }
    }
}

