/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.onlab.util.ByteOperator;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispMessage;
import org.onosproject.lisp.msg.protocols.DefaultLispInfoRequest;
import org.onosproject.lisp.msg.protocols.LispInfo;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.protocols.LispType;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public class DefaultLispInfo
extends AbstractLispMessage
implements LispInfo {
    protected final boolean infoReply;
    protected final long nonce;
    protected final short keyId;
    protected final short authDataLength;
    protected final byte[] authData;
    protected final int ttl;
    protected final byte maskLength;
    protected final LispAfiAddress eidPrefix;
    private static final int INFO_REPLY_INDEX = 3;
    private static final int RESERVED_SKIP_LENGTH_1 = 3;
    private static final int RESERVED_SKIP_LENGTH_2 = 1;
    private static final int INFO_REQUEST_SHIFT_BIT = 4;
    private static final int ENABLE_BIT = 1;
    private static final int DISABLE_BIT = 0;
    private static final int UNUSED_ZERO = 0;

    protected DefaultLispInfo(boolean infoReply, long nonce, short keyId, short authDataLength, byte[] authData, int ttl, byte maskLength, LispAfiAddress eidPrefix) {
        this.infoReply = infoReply;
        this.nonce = nonce;
        this.keyId = keyId;
        this.authDataLength = authDataLength;
        this.authData = authData;
        this.ttl = ttl;
        this.maskLength = maskLength;
        this.eidPrefix = eidPrefix;
    }

    @Override
    public LispType getType() {
        return LispType.LISP_INFO;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        DefaultLispInfo.serialize(byteBuf, this);
    }

    @Override
    public LispMessage.Builder createBuilder() {
        return new DefaultLispInfoRequest.DefaultInfoRequestBuilder();
    }

    @Override
    public boolean isInfoReply() {
        return this.infoReply;
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public short getKeyId() {
        return this.keyId;
    }

    @Override
    public short getAuthDataLength() {
        return this.authDataLength;
    }

    @Override
    public byte[] getAuthData() {
        if (this.authData != null && this.authData.length != 0) {
            return ImmutableByteSequence.copyFrom((byte[])this.authData).asArray();
        }
        return new byte[0];
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    public byte getMaskLength() {
        return this.maskLength;
    }

    @Override
    public LispAfiAddress getPrefix() {
        return this.eidPrefix;
    }

    public static LispInfo deserialize(ByteBuf byteBuf) throws LispParseError, LispReaderException {
        if (byteBuf.readerIndex() != 0) {
            return null;
        }
        boolean infoReplyFlag = ByteOperator.getBit((byte)byteBuf.readByte(), (int)3);
        byteBuf.skipBytes(3);
        long nonce = byteBuf.readLong();
        short keyId = byteBuf.readShort();
        short authLength = byteBuf.readShort();
        byte[] authData = new byte[authLength];
        byteBuf.readBytes(authData);
        int ttl = byteBuf.readInt();
        byteBuf.skipBytes(1);
        short maskLength = byteBuf.readUnsignedByte();
        LispAfiAddress prefix = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
        return new DefaultLispInfo(infoReplyFlag, nonce, keyId, authLength, authData, ttl, (byte)maskLength, prefix);
    }

    public static void serialize(ByteBuf byteBuf, LispInfo message) throws LispWriterException {
        byte msgType = (byte)(LispType.LISP_INFO.getTypeCode() << 4);
        int infoReply = 0;
        if (message.isInfoReply()) {
            infoReply = 8;
        }
        byteBuf.writeByte(msgType + infoReply);
        byteBuf.writeByte(0);
        byteBuf.writeByte(0);
        byteBuf.writeByte(0);
        byteBuf.writeLong(message.getNonce());
        byteBuf.writeShort((int)message.getKeyId());
        byteBuf.writeShort((int)message.getAuthDataLength());
        byte[] data = message.getAuthData();
        if (data != null) {
            byte[] clone = (byte[])data.clone();
            Arrays.fill(clone, (byte)0);
        }
        byteBuf.writeBytes(data);
        byteBuf.writeInt(message.getTtl());
        byteBuf.writeByte(0);
        byteBuf.writeByte((int)message.getMaskLength());
        LispAfiAddress.AfiAddressWriter afiAddressWriter = new LispAfiAddress.AfiAddressWriter();
        afiAddressWriter.writeTo(byteBuf, message.getPrefix());
    }
}

