/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onlab.util.ByteOperator;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.lisp.msg.authentication.LispAuthenticationFactory;
import org.onosproject.lisp.msg.authentication.LispAuthenticationKeyEnum;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispMessage;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapRegister;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultLispMapRegister
extends AbstractLispMessage
implements LispMapRegister {
    private static final Logger log = LoggerFactory.getLogger(DefaultLispMapRegister.class);
    private final long nonce;
    private final short keyId;
    private final short authDataLength;
    private final byte[] authData;
    private final List<LispMapRecord> mapRecords;
    private final boolean proxyMapReply;
    private final boolean wantMapNotify;
    static final RegisterWriter WRITER = new RegisterWriter();

    private DefaultLispMapRegister(long nonce, short keyId, short authDataLength, byte[] authData, List<LispMapRecord> mapRecords, boolean proxyMapReply, boolean wantMapNotify) {
        this.nonce = nonce;
        this.keyId = keyId;
        this.authDataLength = authDataLength;
        this.authData = authData;
        this.mapRecords = mapRecords;
        this.proxyMapReply = proxyMapReply;
        this.wantMapNotify = wantMapNotify;
    }

    @Override
    public LispType getType() {
        return LispType.LISP_MAP_REGISTER;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    @Override
    public LispMessage.Builder createBuilder() {
        return new DefaultRegisterBuilder();
    }

    @Override
    public boolean isProxyMapReply() {
        return this.proxyMapReply;
    }

    @Override
    public boolean isWantMapNotify() {
        return this.wantMapNotify;
    }

    @Override
    public int getRecordCount() {
        return this.mapRecords.size();
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public short getKeyId() {
        return this.keyId;
    }

    @Override
    public short getAuthDataLength() {
        return this.authDataLength;
    }

    @Override
    public byte[] getAuthData() {
        if (this.authData != null && this.authData.length != 0) {
            return ImmutableByteSequence.copyFrom((byte[])this.authData).asArray();
        }
        return new byte[0];
    }

    @Override
    public List<LispMapRecord> getMapRecords() {
        return ImmutableList.copyOf(this.mapRecords);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("nonce", this.nonce).add("keyId", (int)this.keyId).add("authentication data length", (int)this.authDataLength).add("authentication data", (Object)this.authData).add("mapRecords", this.mapRecords).add("proxyMapReply", this.proxyMapReply).add("wantMapNotify", this.wantMapNotify).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispMapRegister that = (DefaultLispMapRegister)o;
        return Objects.equal((Object)this.nonce, (Object)that.nonce) && Objects.equal((Object)this.keyId, (Object)that.keyId) && Objects.equal((Object)this.authDataLength, (Object)that.authDataLength) && Arrays.equals(this.authData, that.authData) && Objects.equal((Object)this.proxyMapReply, (Object)that.proxyMapReply) && Objects.equal((Object)this.wantMapNotify, (Object)that.wantMapNotify);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nonce, this.keyId, this.authDataLength, this.proxyMapReply, this.wantMapNotify}) + Arrays.hashCode(this.authData);
    }

    public static class RegisterWriter
    implements LispMessageWriter<LispMapRegister> {
        private static final int REGISTER_SHIFT_BIT = 4;
        private static final int PROXY_MAP_REPLY_SHIFT_BIT = 3;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispMapRegister message) throws LispWriterException {
            byte msgType = (byte)(LispType.LISP_MAP_REGISTER.getTypeCode() << 4);
            int proxyMapReply = 0;
            if (message.isProxyMapReply()) {
                proxyMapReply = 8;
            }
            byteBuf.writeByte(msgType + proxyMapReply);
            byteBuf.writeByte(0);
            int wantMapNotify = 0;
            if (message.isWantMapNotify()) {
                wantMapNotify = 1;
            }
            byteBuf.writeByte(wantMapNotify);
            byteBuf.writeByte(message.getMapRecords().size());
            byteBuf.writeLong(message.getNonce());
            byteBuf.writeShort((int)message.getKeyId());
            if (message.getAuthData() == null) {
                byteBuf.writeShort(0);
            } else {
                byteBuf.writeShort(message.getAuthData().length);
                byteBuf.writeBytes(message.getAuthData());
            }
            DefaultLispMapRecord.MapRecordWriter writer = new DefaultLispMapRecord.MapRecordWriter();
            List<LispMapRecord> records = message.getMapRecords();
            for (LispMapRecord record : records) {
                writer.writeTo(byteBuf, record);
            }
        }
    }

    public static final class RegisterReader
    implements LispMessageReader<LispMapRegister> {
        private static final int PROXY_MAP_REPLY_INDEX = 3;
        private static final int WANT_MAP_NOTIFY_INDEX = 0;
        private static final int RESERVED_SKIP_LENGTH = 1;

        @Override
        public LispMapRegister readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            if (byteBuf.readerIndex() != 0) {
                return null;
            }
            boolean proxyMapReplyFlag = ByteOperator.getBit((byte)byteBuf.readByte(), (int)3);
            byteBuf.skipBytes(1);
            byte reservedWithFlag = byteBuf.readByte();
            boolean wantMapNotifyFlag = ByteOperator.getBit((byte)reservedWithFlag, (int)0);
            int recordCount = byteBuf.readUnsignedByte();
            long nonce = byteBuf.readLong();
            short keyId = byteBuf.readShort();
            short authLength = byteBuf.readShort();
            byte[] authData = new byte[authLength];
            byteBuf.readBytes(authData);
            ArrayList mapRecords = Lists.newArrayList();
            for (int i = 0; i < recordCount; ++i) {
                mapRecords.add(new DefaultLispMapRecord.MapRecordReader().readFrom(byteBuf));
            }
            return new DefaultRegisterBuilder().withIsProxyMapReply(proxyMapReplyFlag).withIsWantMapNotify(wantMapNotifyFlag).withNonce(nonce).withKeyId(keyId).withAuthData(authData).withAuthDataLength(authLength).withMapRecords(mapRecords).build();
        }
    }

    public static final class DefaultRegisterBuilder
    implements LispMapRegister.RegisterBuilder {
        private long nonce;
        private short keyId;
        private short authDataLength;
        private byte[] authData;
        private String authKey;
        private List<LispMapRecord> mapRecords = Lists.newArrayList();
        private boolean proxyMapReply;
        private boolean wantMapNotify;

        @Override
        public LispType getType() {
            return LispType.LISP_MAP_REGISTER;
        }

        @Override
        public LispMapRegister.RegisterBuilder withIsProxyMapReply(boolean proxyMapReply) {
            this.proxyMapReply = proxyMapReply;
            return this;
        }

        @Override
        public LispMapRegister.RegisterBuilder withIsWantMapNotify(boolean wantMapNotify) {
            this.wantMapNotify = wantMapNotify;
            return this;
        }

        @Override
        public LispMapRegister.RegisterBuilder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public LispMapRegister.RegisterBuilder withAuthKey(String key) {
            this.authKey = key;
            return this;
        }

        @Override
        public LispMapRegister.RegisterBuilder withAuthDataLength(short authDataLength) {
            this.authDataLength = authDataLength;
            return this;
        }

        @Override
        public LispMapRegister.RegisterBuilder withKeyId(short keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public LispMapRegister.RegisterBuilder withAuthData(byte[] authenticationData) {
            if (authenticationData != null) {
                this.authData = authenticationData;
            }
            return this;
        }

        @Override
        public LispMapRegister.RegisterBuilder withMapRecords(List<LispMapRecord> mapRecords) {
            if (mapRecords != null) {
                this.mapRecords = ImmutableList.copyOf(mapRecords);
            }
            return this;
        }

        @Override
        public LispMapRegister build() {
            if (this.authData == null) {
                LispAuthenticationFactory factory = LispAuthenticationFactory.getInstance();
                this.authDataLength = LispAuthenticationKeyEnum.valueOf(this.keyId).getHashLength();
                byte[] tmpAuthData = new byte[this.authDataLength];
                Arrays.fill(tmpAuthData, (byte)0);
                this.authData = tmpAuthData;
                ByteBuf byteBuf = Unpooled.buffer();
                try {
                    new DefaultLispMapRegister(this.nonce, this.keyId, this.authDataLength, this.authData, this.mapRecords, this.proxyMapReply, this.wantMapNotify).writeTo(byteBuf);
                }
                catch (LispWriterException e) {
                    log.warn("Failed to serialize map register message", (Throwable)e);
                }
                byte[] bytes = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(bytes);
                if (this.authKey == null) {
                    log.warn("Must specify authentication key");
                }
                this.authData = factory.createAuthenticationData(LispAuthenticationKeyEnum.valueOf(this.keyId), this.authKey, bytes);
            }
            return new DefaultLispMapRegister(this.nonce, this.keyId, this.authDataLength, this.authData, this.mapRecords, this.proxyMapReply, this.wantMapNotify);
        }
    }
}

