/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.authentication;

import org.onosproject.lisp.msg.authentication.LispAuthenticationKeyEnum;
import org.onosproject.lisp.msg.authentication.LispMacAuthentication;

public final class LispAuthenticationFactory {
    private LispAuthenticationFactory() {
    }

    public static LispAuthenticationFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public byte[] createAuthenticationData(LispAuthenticationKeyEnum authType, String authKey, byte[] data) {
        byte[] authData;
        LispMacAuthentication macAuth = new LispMacAuthentication(authType);
        switch (authType) {
            case SHA1: 
            case SHA256: {
                authData = macAuth.getAuthenticationData(authKey, data);
                break;
            }
            default: {
                authData = macAuth.getAuthenticationData();
            }
        }
        return authData;
    }

    private static final class SingletonHelper {
        private static final LispAuthenticationFactory INSTANCE = new LispAuthenticationFactory();
        private static final String ILLEGAL_ACCESS_MSG = "Should not instantiate this class.";

        private SingletonHelper() {
            throw new IllegalAccessError(ILLEGAL_ACCESS_MSG);
        }
    }
}

