/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.authentication;

public enum LispAuthenticationKeyEnum {
    NONE(0, null, 0),
    SHA1(1, "HmacSHA1", 20),
    SHA256(2, "HmacSHA256", 32),
    UNKNOWN(-1, "UNKNOWN", 0);

    private short keyId;
    private String name;
    private short length;

    private LispAuthenticationKeyEnum(int keyId, String name, int length) {
        this.keyId = (short)keyId;
        this.name = name;
        this.length = (short)length;
    }

    public short getKeyId() {
        return this.keyId;
    }

    public String getName() {
        return this.name;
    }

    public short getHashLength() {
        return this.length;
    }

    public static LispAuthenticationKeyEnum valueOf(short keyId) {
        for (LispAuthenticationKeyEnum val : LispAuthenticationKeyEnum.values()) {
            if (val.getKeyId() != keyId) continue;
            return val;
        }
        return UNKNOWN;
    }
}

