/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.authentication;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.onosproject.lisp.msg.authentication.LispAuthenticationKeyEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispMacAuthentication {
    private static final Logger log = LoggerFactory.getLogger(LispMacAuthentication.class);
    private static final String NOT_SUPPORT_ALGORITHM_MSG = "Not support provided algorithm {}";
    private static final String INVALID_KEY_MSG = "Provided key {} is invalid";
    private String algorithm;

    LispMacAuthentication(LispAuthenticationKeyEnum authType) {
        if (authType == LispAuthenticationKeyEnum.SHA1 || authType == LispAuthenticationKeyEnum.SHA256) {
            this.algorithm = authType.getName();
        } else {
            log.warn(NOT_SUPPORT_ALGORITHM_MSG, (Object)authType.getName());
        }
    }

    byte[] getAuthenticationData() {
        return new byte[0];
    }

    byte[] getAuthenticationData(String key, byte[] data) {
        try {
            SecretKeySpec signKey = new SecretKeySpec(key.getBytes(), this.algorithm);
            Mac mac = Mac.getInstance(this.algorithm);
            mac.init(signKey);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            log.warn(NOT_SUPPORT_ALGORITHM_MSG, (Object)this.algorithm, (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            log.warn(INVALID_KEY_MSG, (Object)key, (Object)e.getMessage());
            throw new IllegalArgumentException(e);
        }
    }
}

