/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispMessage;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapReply;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispType;

public final class DefaultLispMapReply
extends AbstractLispMessage
implements LispMapReply {
    private final long nonce;
    private final boolean probe;
    private final boolean etr;
    private final boolean security;
    private final List<LispMapRecord> mapRecords;
    static final ReplyWriter WRITER = new ReplyWriter();

    private DefaultLispMapReply(long nonce, boolean probe, boolean etr, boolean security, List<LispMapRecord> mapRecords) {
        this.nonce = nonce;
        this.probe = probe;
        this.etr = etr;
        this.security = security;
        this.mapRecords = mapRecords;
    }

    @Override
    public LispType getType() {
        return LispType.LISP_MAP_REPLY;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    @Override
    public LispMessage.Builder createBuilder() {
        return new DefaultReplyBuilder();
    }

    @Override
    public boolean isProbe() {
        return this.probe;
    }

    @Override
    public boolean isEtr() {
        return this.etr;
    }

    @Override
    public boolean isSecurity() {
        return this.security;
    }

    @Override
    public int getRecordCount() {
        return this.mapRecords.size();
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public List<LispMapRecord> getMapRecords() {
        return ImmutableList.copyOf(this.mapRecords);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("nonce", this.nonce).add("probe", this.probe).add("etr", this.etr).add("security", this.security).add("map records", this.mapRecords).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispMapReply that = (DefaultLispMapReply)o;
        return Objects.equal((Object)this.nonce, (Object)that.nonce) && Objects.equal((Object)this.probe, (Object)that.probe) && Objects.equal((Object)this.etr, (Object)that.etr) && Objects.equal((Object)this.security, (Object)that.security) && Objects.equal(this.mapRecords, that.mapRecords);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nonce, this.probe, this.etr, this.security, this.mapRecords});
    }

    public static final class ReplyWriter
    implements LispMessageWriter<LispMapReply> {
        private static final int REPLY_SHIFT_BIT = 4;
        private static final int PROBE_FLAG_SHIFT_BIT = 3;
        private static final int ETR_FLAG_SHIFT_BIT = 2;
        private static final int SECURITY_FLAG_SHIFT_BIT = 1;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispMapReply message) throws LispWriterException {
            byte msgType = (byte)(LispType.LISP_MAP_REPLY.getTypeCode() << 4);
            int probe = 0;
            if (message.isProbe()) {
                probe = 8;
            }
            int etr = 0;
            if (message.isEtr()) {
                etr = 4;
            }
            int security = 0;
            if (message.isSecurity()) {
                security = 2;
            }
            byteBuf.writeByte((int)((byte)(msgType + probe + etr + security)));
            byteBuf.writeShort(0);
            byteBuf.writeByte(message.getMapRecords().size());
            byteBuf.writeLong(message.getNonce());
            DefaultLispMapRecord.MapRecordWriter writer = new DefaultLispMapRecord.MapRecordWriter();
            List<LispMapRecord> records = message.getMapRecords();
            for (LispMapRecord record : records) {
                writer.writeTo(byteBuf, record);
            }
        }
    }

    public static final class ReplyReader
    implements LispMessageReader<LispMapReply> {
        private static final int PROBE_INDEX = 3;
        private static final int ETR_INDEX = 2;
        private static final int SECURITY_INDEX = 1;
        private static final int RESERVED_SKIP_LENGTH = 2;

        @Override
        public LispMapReply readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            if (byteBuf.readerIndex() != 0) {
                return null;
            }
            byte typeWithFlags = byteBuf.readByte();
            boolean probe = ByteOperator.getBit((byte)typeWithFlags, (int)3);
            boolean etr = ByteOperator.getBit((byte)typeWithFlags, (int)2);
            boolean security = ByteOperator.getBit((byte)typeWithFlags, (int)1);
            byteBuf.skipBytes(2);
            int recordCount = byteBuf.readUnsignedByte();
            long nonce = byteBuf.readLong();
            ArrayList mapRecords = Lists.newArrayList();
            for (int i = 0; i < recordCount; ++i) {
                mapRecords.add(new DefaultLispMapRecord.MapRecordReader().readFrom(byteBuf));
            }
            return new DefaultReplyBuilder().withIsProbe(probe).withIsEtr(etr).withIsSecurity(security).withNonce(nonce).withMapRecords(mapRecords).build();
        }
    }

    public static final class DefaultReplyBuilder
    implements LispMapReply.ReplyBuilder {
        private long nonce;
        private boolean probe;
        private boolean etr;
        private boolean security;
        private List<LispMapRecord> mapRecords = Lists.newArrayList();

        @Override
        public LispType getType() {
            return LispType.LISP_MAP_REPLY;
        }

        @Override
        public LispMapReply.ReplyBuilder withIsProbe(boolean probe) {
            this.probe = probe;
            return this;
        }

        @Override
        public LispMapReply.ReplyBuilder withIsEtr(boolean etr) {
            this.etr = etr;
            return this;
        }

        @Override
        public LispMapReply.ReplyBuilder withIsSecurity(boolean security) {
            this.security = security;
            return this;
        }

        @Override
        public LispMapReply.ReplyBuilder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public LispMapReply.ReplyBuilder withMapRecords(List<LispMapRecord> mapRecords) {
            if (this.mapRecords != null) {
                this.mapRecords = ImmutableList.copyOf(mapRecords);
            }
            return this;
        }

        @Override
        public LispMapReply build() {
            return new DefaultLispMapReply(this.nonce, this.probe, this.etr, this.security, this.mapRecords);
        }
    }
}

