/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.DeserializationException;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispRecord;
import org.onosproject.lisp.msg.protocols.DefaultLispReferral;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispReferral;
import org.onosproject.lisp.msg.protocols.LispReferralRecord;
import org.onosproject.lisp.msg.protocols.LispSignature;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class DefaultLispReferralRecord
extends AbstractLispRecord
implements LispReferralRecord {
    private final boolean incomplete;
    private final List<LispReferral> referrals;
    private final List<LispSignature> signatures;
    static final ReferralRecordWriter WRITER = new ReferralRecordWriter();

    private DefaultLispReferralRecord(int recordTtl, byte maskLength, LispMapReplyAction action, boolean authoritative, short mapVersionNumber, LispAfiAddress eidPrefixAfi, boolean incomplete, List<LispReferral> referrals, List<LispSignature> signatures) {
        super(recordTtl, maskLength, action, authoritative, mapVersionNumber, eidPrefixAfi);
        this.incomplete = incomplete;
        this.referrals = referrals;
        this.signatures = signatures;
    }

    @Override
    public int getReferralCount() {
        return this.referrals.size();
    }

    @Override
    public int getSignatureCount() {
        return this.signatures.size();
    }

    @Override
    public boolean isIncomplete() {
        return this.incomplete;
    }

    @Override
    public List<LispReferral> getReferrals() {
        return ImmutableList.copyOf(this.referrals);
    }

    @Override
    public List<LispSignature> getSignatures() {
        return ImmutableList.copyOf(this.signatures);
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("record TTL", this.recordTtl).add("maskLength", (int)this.maskLength).add("action", (Object)this.action).add("authoritative", this.authoritative).add("mapVersionNumber", (int)this.mapVersionNumber).add("EID prefix AFI address", (Object)this.eidPrefixAfi).add("incomplete", this.incomplete).add("referrals", this.referrals).add("signatures", this.signatures).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispReferralRecord that = (DefaultLispReferralRecord)o;
        return Objects.equal((Object)this.recordTtl, (Object)that.recordTtl) && Objects.equal((Object)this.maskLength, (Object)that.maskLength) && Objects.equal((Object)((Object)this.action), (Object)((Object)that.action)) && Objects.equal((Object)this.authoritative, (Object)that.authoritative) && Objects.equal((Object)this.mapVersionNumber, (Object)that.mapVersionNumber) && Objects.equal((Object)this.eidPrefixAfi, (Object)that.eidPrefixAfi) && Objects.equal(this.referrals, that.referrals) && Objects.equal(this.signatures, that.signatures);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.recordTtl, this.maskLength, this.action, this.authoritative, this.mapVersionNumber, this.eidPrefixAfi, this.incomplete, this.referrals, this.signatures});
    }

    public static final class ReferralRecordWriter
    implements LispMessageWriter<LispReferralRecord> {
        private static final int REPLY_ACTION_SHIFT_BIT = 5;
        private static final int INCOMPLETE_SHIFT_BIT = 3;
        private static final int AUTHORITATIVE_SHIFT_BIT = 4;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispReferralRecord message) throws LispWriterException {
            byteBuf.writeInt(message.getRecordTtl());
            byteBuf.writeByte((int)((byte)message.getReferrals().size()));
            byteBuf.writeByte((int)message.getMaskLength());
            byte action = (byte)(message.getAction().getAction() << 5);
            int authoritative = 0;
            if (message.isAuthoritative()) {
                authoritative = 16;
            }
            int incomplete = 0;
            if (message.isIncomplete()) {
                incomplete = 8;
            }
            byteBuf.writeByte((int)((byte)(action + authoritative + incomplete)));
            byteBuf.writeByte(0);
            byteBuf.writeShort((int)message.getMapVersionNumber());
            LispAfiAddress.AfiAddressWriter afiAddressWriter = new LispAfiAddress.AfiAddressWriter();
            afiAddressWriter.writeTo(byteBuf, message.getEidPrefixAfi());
            DefaultLispReferral.ReferralWriter referralWriter = new DefaultLispReferral.ReferralWriter();
            List<LispReferral> referrals = message.getReferrals();
            for (LispReferral referral : referrals) {
                referralWriter.writeTo(byteBuf, referral);
            }
        }
    }

    public static final class ReferralRecordReader
    implements LispMessageReader<LispReferralRecord> {
        private static final int INCOMPLETE_INDEX = 3;
        private static final int AUTHORITATIVE_INDEX = 4;
        private static final int REPLY_ACTION_SHIFT_BIT = 5;
        private static final int RESERVED_SKIP_LENGTH = 1;

        @Override
        public LispReferralRecord readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException, DeserializationException {
            int recordTtl = byteBuf.readInt();
            int referralCount = byteBuf.readUnsignedByte();
            byte maskLength = (byte)byteBuf.readUnsignedByte();
            byte actionWithFlag = (byte)byteBuf.readUnsignedByte();
            int actionByte = actionWithFlag >> 5;
            LispMapReplyAction action = LispMapReplyAction.valueOf(actionByte);
            if (action == null) {
                action = LispMapReplyAction.NoAction;
            }
            boolean authoritative = ByteOperator.getBit((byte)((byte)(actionWithFlag >> 4)), (int)0);
            boolean incomplete = ByteOperator.getBit((byte)((byte)(actionWithFlag >> 3)), (int)0);
            byteBuf.skipBytes(1);
            short mapVersionNumber = (short)byteBuf.readUnsignedShort();
            LispAfiAddress eidPrefixAfi = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            ArrayList referrals = Lists.newArrayList();
            for (int i = 0; i < referralCount; ++i) {
                referrals.add(new DefaultLispReferral.ReferralReader().readFrom(byteBuf));
            }
            return ((LispReferralRecord.ReferralRecordBuilder)((LispReferralRecord.ReferralRecordBuilder)((LispReferralRecord.ReferralRecordBuilder)((LispReferralRecord.ReferralRecordBuilder)((LispReferralRecord.ReferralRecordBuilder)((LispReferralRecord.ReferralRecordBuilder)new DefaultReferralRecordBuilder().withRecordTtl(recordTtl)).withMaskLength(maskLength)).withAction(action)).withIsAuthoritative(authoritative)).withIsIncomplete(incomplete).withMapVersionNumber(mapVersionNumber)).withReferrals(referrals).withEidPrefixAfi(eidPrefixAfi)).build();
        }
    }

    public static final class DefaultReferralRecordBuilder
    extends AbstractLispRecord.AbstractRecordBuilder<LispReferralRecord.ReferralRecordBuilder>
    implements LispReferralRecord.ReferralRecordBuilder {
        private boolean incomplete;
        private List<LispReferral> referrals = Lists.newArrayList();
        private List<LispSignature> signatures = Lists.newArrayList();

        @Override
        public LispReferralRecord.ReferralRecordBuilder withReferrals(List<LispReferral> referrals) {
            if (referrals != null) {
                this.referrals = ImmutableList.copyOf(referrals);
            }
            return this;
        }

        @Override
        public LispReferralRecord.ReferralRecordBuilder withSignatures(List<LispSignature> signatures) {
            if (signatures != null) {
                this.signatures = ImmutableList.copyOf(signatures);
            }
            return this;
        }

        @Override
        public LispReferralRecord.ReferralRecordBuilder withIsIncomplete(boolean incomplete) {
            this.incomplete = incomplete;
            return this;
        }

        @Override
        public LispReferralRecord build() {
            Preconditions.checkNotNull((Object)this.eidPrefixAfi, (Object)"Must specify an EID prefix");
            return new DefaultLispReferralRecord(this.recordTtl, this.maskLength, this.action, this.authoritative, this.mapVersionNumber, this.eidPrefixAfi, this.incomplete, this.referrals, this.signatures);
        }
    }
}

